import Joi from 'joi';
import express from 'express';

import crypto from '../../crypto';
import mailer from '../../mailer';
import { permission } from '../../middlewares/permission';
import { randomString } from '../../functions';
import { checkCompanyValidityStrategy, checkTaConnectionStrategy, jwtStrategy} from '../../middlewares/strategy';
import { validateBody } from '../../middlewares/validator';
import rateLimit from 'express-rate-limit';


const strictLimiter = rateLimit({
    windowMs: 1 * 60 * 1000, // 1 minute
    max: 5, // 5 requests per minute
    message: "Too many requests to this endpoint, please try again later.",
});


let validator = Joi.object().keys({
    employeeId: Joi.string().hex().length(24).required()
});

let controller = async (req, res, next) => {
    try {

        const { employeeId } = req.query;
        const token = randomString(20);
        const companyId = req.user.companyId;

        const employee = await db.Employee.findOne({ 
            _id: employeeId,
            companyId, 
            deletedAt: null
        });
        if(!employee){
            throw new RequestError('Employee not Found', 404);
        }
        employee['verfKey'] = token;
        employee['verfKeyExpiry'] = new Date();
        await employee.save();
        let encryptEmail = await crypto.encrypt(employee.email);
        encryptEmail = encodeURIComponent(encryptEmail);
        await mailer.sendResetLink(employee.firstName, employee.email, encryptEmail, token, companyId); 

        return res.status(200).send({ success:true, message: 'Reset password link has been sent successfully'});
    } catch (error) {        
        return next(new RequestError(error))
    }
}
const apiRouter = express.Router();
apiRouter.route('/').get(strictLimiter, jwtStrategy, checkTaConnectionStrategy, checkCompanyValidityStrategy, permission('IAM','Write'), validateBody(validator), controller);
export default apiRouter;