import Joi from "joi";
import express from "express";
import { checkCompanyValidityStrategy, checkTaConnectionStrategy, jwtStrategy } from "../../middlewares/strategy";
import { permission } from "../../middlewares/permission";
import { validateBody } from "../../middlewares/validator";
import { htmlsanitize } from "../../middlewares/sanitizeHtml";
import rateLimit from 'express-rate-limit';


const strictLimiter = rateLimit({
    windowMs: 1 * 60 * 1000, // 1 minute
    max: 5, // 5 requests per minute
    message: "Too many requests to this endpoint, please try again later.",
  });


let validator = Joi.object().keys({
  firstName: Joi.string().required(),
  lastName: Joi.string().allow(null,'').required(),
  email: Joi.string().required(),

});


let controller = async (req, res, next) => {
  try {
    const companyId = req.user.companyId
    let { email, firstName, lastName = " " } = req.body;
    let employee = await db.Employee.findOne({ email, companyId });
    if (!employee) {
      throw new RequestError("Employee not found");
    }
       employee.firstName = firstName;
       employee.lastName = lastName;
      await employee.save();
    res
      .status(201)
      .send({
        success: true,
        message: "Details updted sucessfuly",
        employeeId: employee._id
      });
  } catch (err) {
    console.log(err);
    next(err);
  }
};

const apiRouter = express.Router();
apiRouter
  .route("/")
  .post(
    strictLimiter,
    htmlsanitize(),
    validateBody(validator),
    jwtStrategy,
    checkTaConnectionStrategy,
    checkCompanyValidityStrategy,
    permission("IAM", "Write"),
    controller
  );
export default apiRouter;