// import fs from 'fs';
// import Joi from 'joi';
// import path from 'path';
// import express from 'express';

// import { sanitize } from '../../middlewares/sanitizer';
// import { jwtStrategy } from '../../middlewares/strategy';
// import { validateBody } from '../../middlewares/validator';
// import { permission } from '../../middlewares/permission'

// let validator = Joi.object().keys({
//     attachmentId: Joi.string().hex().length(24).required()
// });

// let controller = async (req, res, next) => {
// 	try {
		
// 		const { attachmentId } = req.query;
// 		const attachment = await db.Attachment.findOne({ _id: attachmentId }).select('fileName').populate('fileName')
// 		if (!attachment) {
// 			throw new RequestError('invalid attachmentId');
// 		}
// 		const fileName = attachment.fileName;
// 		const filePath = path.join(appRoot, 'Content', 'MailAttachments', fileName);

// 		try {
// 			res.writeHead(200, {
// 				"Content-Type": "application/octet-stream",
// 				"Content-Disposition": "attachment; filename=" + fileName
// 			});
// 			fs.createReadStream(filePath).pipe(res);
// 		} catch (error) {
// 			throw new RequestError('file not exists');
// 		}

// 	} catch (error) {
// 		console.log(error);
// 		next(error)
// 	}
// }

// const apiRouter = express.Router();
// apiRouter.route('/').get(sanitize(), validateBody(validator), jwtStrategy, permission('Users','Write'), controller);
// export default apiRouter;



import express from 'express';

import s3 from '../../Content/upload_file'
import { sanitize } from '../../middlewares/sanitizer';
import { jwtStrategy } from '../../middlewares/strategy';
import config from '../../config'
import { htmlsanitize } from '../../middlewares/sanitizeHtml';

// import { validateBody } from '../../middlewares/validator';

// let validator = Joi.object().keys({
//     urlIds: Joi.array().items(
//         Joi.string().hex().length(24).required()
//     ).required(),
//     reportedMailId: Joi.string().hex().length(24).required()
// });


/**
 * @api {post} /api/v1/scan/scan-url scan-url
 * @apiName scan-url
 * @apiGroup scan
 * @apiDescription Scan a url
 * 
 * @apiVersion 1.0.0
 * 
 * @apiBody   {String}   urlId        		 urlId of the reported mail
 * @apiBody   {String}   reportedMailId      Id of the reported mail
 * 
 * @apiSuccess {Boolean} Success             true
 * @apiSuccess {String}  Message             Scan now in processing, Result Will be Updated Soon!
 * 
 * @apiSuccessExample Success-Response:
 *      HTTP/1.1 200 OK 
 * {
 *           "Success": true,
 *           "Message": "Scan now in processing, Result Will be Updated Soon!"
 * }
 * 
 * @apiError {Boolean} Success             false
 * @apiError {Array}   messages            "\"reportedMailId\" is not allowed to be empty"
 * 
 * @apiSuccessExample Error-Response:
 *       HTTP/1.1 400 Not Found
 * 
 *      "success":   false,
 *      "messages" : "\"reportedMailId\" is not allowed to be empty"
 * 
 */

let controller = async (req, res, next) => {
	try {
		const { attachmentId } = req.query; 
        const attachment = await db.Attachment.findById(attachmentId)

		console.log("attachment in download-----", attachment);
		console.log("reportedMailId=========",attachment.reportedMailId.toString());
		console.log("attachment.fileName======",attachment.fileName);
		
		let file = await s3.fetchReportedMailAttachments(attachment.reportedMailId.toString(), attachment.fileName)
		console.log("file in download-----------", file)
		if(file){
		if(config.s3.isSASS){
				res.setHeader('Content-Disposition', `attachment; filename="${attachment.fileName}"`);
				res.setHeader("Content-Type", attachment.attachmentType || "application/octet-stream");
				res.send(file)
			}
			else{
				res.writeHead(200, {
					"Content-Type": "application/octet-stream",
					"Content-Disposition": "attachment; filename=" + attachment.fileName
				});
				file.pipe(res);
			}
		}
		else{
			throw new RequestError('File Not Found!');
		}

	} catch (error) {
		console.log(error);
		next(error);
	}
};

const apiRouter = express.Router();
apiRouter.route('/').get(htmlsanitize(), jwtStrategy, controller);
export default apiRouter;