import Joi from 'joi';
import express from 'express';

import { checkCompanyValidityStrategy, checkLicenseStrategy, checkTaConnectionStrategy, jwtStrategy } from '../../middlewares/strategy';
import { validateBody } from '../../middlewares/validator';
import { permission } from '../../middlewares/permission';
import { updateActivationStautsOfUsers } from '../../service/update-activation-status-users';

const validator = Joi.object().keys({
    groupName: Joi.string().required(),
    users: Joi.array().required(),
    groupId: Joi.string().hex().length(24).optional(),
    isCreatingGroupBeforeUploadingUser: Joi.boolean().required()
});


const controller = async (req, res, next) => {
    try {
        const { users, groupId, groupName, isCreatingGroupBeforeUploadingUser } = req.body;
        const { companyId } = req.user

        const isTacEnabled = (await db.Company.findById(companyId)).isTacEnabled
        // if (!users.length) throw new RequestError("Please select users to add to group!")
        const query = { groupName: { $regex: new RegExp(`^${groupName}$`, 'i') }, companyId, deletedAt: null };        
        if (groupId) {
            query._id = { $ne: groupId };
        }

        const groupWithSameNameExists = await db.Group.findOne(query);
        console.log({groupWithSameNameExists})
        if(groupWithSameNameExists) throw new RequestError(`A group named ${groupName} already exists!`)

        let group = await db.Group.findOne({ _id: groupId, companyId, deletedAt: null });
        var showRemainingLimitError = {error: false, message: ''};
        
        if (!group) {
            var newGroup = await db.Group.create({ companyId, groupName, type: isTacEnabled ? 'Custom' : 'Admin' })
            if(users.length) {
                const updateUsers = Promise.all((users).map(async (user) => {
                    const update = await db.User.updateOne({ _id: user._id, companyId, deletedAt: null }, { $addToSet: { groups: newGroup._id } })
                    return true
                }))
            }
            if(!isCreatingGroupBeforeUploadingUser && !users.length) {
                await db.Group.deleteOne({_id: newGroup._id, companyId})
                throw new RequestError("Please select users to add to group!")
            }
        }
        else {
            if(group.isDefaultGroup) throw new RequestError("all-users-tpir group's details can only be viewed.")

            await db.Group.updateOne({ _id: groupId, companyId }, { $set: { groupName } })
            if (group.emailAccess && !group.messengerAccess) {
                let activeGroupsOfCompany = await db.Group.find({ companyId, deletedAt: null, emailAccess: true }).select("_id")
                let usrs = users.map(user => user._id)

                let usersThatDontBelongToAnyGroupInCompanyWithEmailAccess;
                if (activeGroupsOfCompany.length > 0) usersThatDontBelongToAnyGroupInCompanyWithEmailAccess = await db.User.find({ companyId, _id: { $in: usrs }, groups: { $nin: activeGroupsOfCompany } })

                let userCountForGroupsWhichHaveEmailAccess = 0
                if (activeGroupsOfCompany.length > 0) userCountForGroupsWhichHaveEmailAccess = await db.User.countDocuments({ companyId, deletedAt: null, groups: { $in: activeGroupsOfCompany } })
                console.log({ userCountForGroupsWhichHaveEmailAccess })

                let userLimit = (await db.MetaData.findOne({ name: "userLimit", deletedAt: null, companyId })).value
                let remainingLimit = Math.max(0, userLimit - userCountForGroupsWhichHaveEmailAccess)
                console.log({ remainingLimit })

                let usersThatAlreadyBelongToAnyGroupInCompanyWithEmailAccess = await db.User.find({ companyId, _id: { $in: usrs }, groups: { $in: activeGroupsOfCompany } })
                if (remainingLimit > 0) {
                    let usersToBeAdded = usersThatDontBelongToAnyGroupInCompanyWithEmailAccess.slice(0, remainingLimit)
                    const updateUsers = Promise.all(([...usersThatAlreadyBelongToAnyGroupInCompanyWithEmailAccess, ...usersToBeAdded]).map(async (user) => {
                        const update = await db.User.updateOne({ _id: user._id, companyId, deletedAt: null }, { $addToSet: { groups: groupId } })
                        return true
                    }))
                }
                else {
                    const updateUsers = Promise.all(((usersThatAlreadyBelongToAnyGroupInCompanyWithEmailAccess)).map(async (user) => {
                        const update = await db.User.updateOne({ _id: user._id, companyId, deletedAt: null }, { $addToSet: { groups: groupId } })
                        return true
                    }))
                }

                if(usersThatDontBelongToAnyGroupInCompanyWithEmailAccess.length > remainingLimit){
                    showRemainingLimitError = {error: true, message: "Number of users selected exceeds remaining limit of users that can be granted email access so only users that already belong to group with email access will be added to group!"}
                }
                await db.User.updateMany({companyId, deletedAt:null, _id:{$nin:usrs}},{$pull: { groups: groupId } })
                await updateActivationStautsOfUsers(companyId)
            }
            if (group.messengerAccess && !group.emailAccess) {
                let activeGroupsOfCompany = await db.Group.find({ companyId, deletedAt: null, messengerAccess: true }).select("_id")
                let usrs = users.map(user => user._id)

                let usersThatDontBelongToAnyGroupInCompanyWithMessengerAccess;
                if (activeGroupsOfCompany.length > 0) usersThatDontBelongToAnyGroupInCompanyWithMessengerAccess = await db.User.find({ companyId, _id: { $in: usrs }, groups: { $nin: activeGroupsOfCompany } })

                let userCountForGroupsWhichHaveMessengerAccess = 0
                if (activeGroupsOfCompany.length > 0) userCountForGroupsWhichHaveMessengerAccess = await db.User.countDocuments({ companyId, deletedAt: null, groups: { $in: activeGroupsOfCompany } })
                console.log({ userCountForGroupsWhichHaveMessengerAccess })

                let userLimit = (await db.MetaData.findOne({ name: "userLimitMessenger", deletedAt: null, companyId })).value
                let remainingLimit = Math.max(0, userLimit - userCountForGroupsWhichHaveMessengerAccess)
                console.log({ remainingLimit })

                let usersThatAlreadyBelongToAnyGroupInCompanyWithMessengerAccess = await db.User.find({ companyId, _id: { $in: usrs }, groups: { $in: activeGroupsOfCompany } })
                if (remainingLimit > 0) {
                    let usersToBeAdded = usersThatDontBelongToAnyGroupInCompanyWithMessengerAccess.slice(0, remainingLimit)
                    const updateUsers = Promise.all(([...usersThatAlreadyBelongToAnyGroupInCompanyWithMessengerAccess, ...usersToBeAdded]).map(async (user) => {
                        const update = await db.User.updateOne({ _id: user._id, companyId, deletedAt: null }, { $addToSet: { groups: groupId } })
                        return true
                    }))
                }
                else {
                    const updateUsers = Promise.all(((usersThatAlreadyBelongToAnyGroupInCompanyWithMessengerAccess)).map(async (user) => {
                        const update = await db.User.updateOne({ _id: user._id, companyId, deletedAt: null }, { $addToSet: { groups: groupId } })
                        return true
                    }))
                }
                if(usersThatDontBelongToAnyGroupInCompanyWithMessengerAccess.length > remainingLimit){
                    showRemainingLimitError = {error: true, message:"Number of users selected exceeds remaining limit of users that can be granted whatsapp access so only users that already belong to group with whatsapp access will be added to group!"}
                }
                await db.User.updateMany({companyId, deletedAt:null, _id:{$nin:usrs}},{$pull: { groups: groupId } })
                await updateActivationStautsOfUsers(companyId)
            }
            if (group.emailAccess && group.messengerAccess) {
                let activeGroupsOfCompanyWithEmailAccess = await db.Group.find({
                    companyId,
                    deletedAt: null,
                    emailAccess: true,
                }).select("_id");

                let activeGroupsOfCompanyWithMessengerAccess = await db.Group.find({
                    companyId,
                    deletedAt: null,
                    messengerAccess: true,
                }).select("_id");

                let usrs = users.map((user) => user._id);

                let usersThatDontBelongToAnyRelevantGroup;
                if (
                    activeGroupsOfCompanyWithEmailAccess.length > 0 &&
                    activeGroupsOfCompanyWithMessengerAccess.length > 0
                ) {
                    usersThatDontBelongToAnyRelevantGroup = await db.User.find({
                        companyId,
                        _id: { $in: usrs },
                        groups: {
                            $nin: [
                                ...activeGroupsOfCompanyWithEmailAccess,
                                ...activeGroupsOfCompanyWithMessengerAccess,
                            ],
                        },
                    });
                }

                let userLimitEmail = (
                    await db.MetaData.findOne({
                        name: "userLimit",
                        deletedAt: null,
                        companyId,
                    })
                ).value;

                let userLimitMessenger = (
                    await db.MetaData.findOne({
                        name: "userLimitMessenger",
                        deletedAt: null,
                        companyId,
                    })
                ).value;

                let userCountWithEmailAccess = 0;
                if (activeGroupsOfCompanyWithEmailAccess.length > 0) {
                    userCountWithEmailAccess = await db.User.countDocuments({
                        companyId,
                        deletedAt: null,
                        groups: { $in: activeGroupsOfCompanyWithEmailAccess },
                    });
                }

                let userCountWithMessengerAccess = 0;
                if (activeGroupsOfCompanyWithMessengerAccess.length > 0) {
                    userCountWithMessengerAccess = await db.User.countDocuments({
                        companyId,
                        deletedAt: null,
                        groups: { $in: activeGroupsOfCompanyWithMessengerAccess },
                    });
                }

                let remainingLimitEmail = Math.max(0, userLimitEmail - userCountWithEmailAccess);
                let remainingLimitMessenger = Math.max(
                    0,
                    userLimitMessenger - userCountWithMessengerAccess
                );

                let remainingLimit = Math.min(remainingLimitEmail, remainingLimitMessenger);

                let usersToBeAdded = [];
                if (remainingLimit > 0 && usersThatDontBelongToAnyRelevantGroup) {
                    usersToBeAdded = usersThatDontBelongToAnyRelevantGroup.slice(
                        0,
                        remainingLimit
                    );
                }

                let usersThatAlreadyBelongToRelevantGroups = await db.User.find({
                    companyId,
                    _id: { $in: usrs },
                    groups: {
                        $in: [
                            ...activeGroupsOfCompanyWithEmailAccess,
                            ...activeGroupsOfCompanyWithMessengerAccess,
                        ],
                    },
                });

                const updateUsers = Promise.all(
                    [
                        ...usersThatAlreadyBelongToRelevantGroups,
                        ...usersToBeAdded,
                    ].map(async (user) => {
                        await db.User.updateOne(
                            { _id: user._id, companyId, deletedAt: null },
                            { $addToSet: { groups: groupId } }
                        );
                        return true;
                    })
                );
                if(usersThatDontBelongToAnyRelevantGroup.length > remainingLimit){
                    showRemainingLimitError = {error: true, message:"Number of users selected exceeds remaining limit of users that can be granted email access and whatsapp access so only users that already belong to group with both access will be added to group!"}
                }
                await db.User.updateMany({companyId, deletedAt:null, _id:{$nin:usrs}},{$pull: { groups: groupId } })
                await updateActivationStautsOfUsers(companyId)
            }
            if (!group.emailAccess && !group.messengerAccess) {
                console.log({users})

                let userIds = users.map(user=>user._id.toString())
                userIds = [...new Set(userIds)]
 
                const updateUsers = await db.User.updateMany({companyId, deletedAt:null, _id:{$in:userIds}},{$addToSet: { groups: groupId } })
                await db.User.updateMany({companyId, deletedAt:null, _id:{$nin:userIds}},{$pull: { groups: groupId } })
                await updateActivationStautsOfUsers(companyId)

            }
            if(users.length == 0 && !isCreatingGroupBeforeUploadingUser) await db.Group.deleteOne({_id: groupId, companyId, isDefaultGroup: false})
        }

        return res.status(200).send({ success: true, message: 
            // (users.length == 0 && !isCreatingGroupBeforeUploadingUser) ? "Please select users to add to group!" : 
            "Group details successfully updated!", groupId: newGroup?._id, showRemainingLimitError })
    } catch (error) {
        console.log('error', error);
        next(error)
    }
}

const apiRouter = express.Router();
apiRouter.route('/').post(jwtStrategy,
    // checkTaConnectionStrategy,
    checkCompanyValidityStrategy, 
    permission('Users', 'Read'),
    validateBody(validator),
    controller);
export default apiRouter;