import Joi from 'joi';
import express from 'express';
import mongoose from 'mongoose';

import { checkTaConnectionStrategy, jwtStrategy } from '../../middlewares/strategy';
import { validateBody } from '../../middlewares/validator';
import { permission } from '../../middlewares/permission';


const validator = Joi.object().keys({
    groupId: Joi.string().hex().length(24).required(),
});


const controller = async (req, res, next) => {
    try {
        const { groupId } = req.body;
        const { companyId } = req.user

        const isTacEnabled = (await db.Company.findById(companyId)).isTacEnabled

        let group = await db.Group.findOne({_id: groupId, companyId, deletedAt: null})
        if(!group) throw new RequestError("Group not found!")
        
        if(group.isSyncingUsers) throw new RequestError("Syncing in progress kindly wait until syncing is complete!")

        if(group.groupName == 'all-users-tpir' && group.defaultGroup) throw new RequestError("Default group cannot be deleted!")
        if(isTacEnabled && group.type == 'Admin') throw new RequestError("Admin group can only be deleted from TA!")

        // let groupsOfCompanyWithEmailAccess = await db.Group.find({companyId, emailAccess:true, deletedAt: null}).select('_id')
        // groupsOfCompanyWithEmailAccess = groupsOfCompanyWithEmailAccess.map(group=>group._id)
        // let groupsOfCompanyWithMessengerAccess = await db.Group.find({companyId, messengerAccess:true, deletedAt: null}).select('_id')
        // groupsOfCompanyWithMessengerAccess = groupsOfCompanyWithMessengerAccess.map(group=>group._id)

        
        // if((isTacEnabled && group.type == "Custom") || (!isTacEnabled && group.type == 'Admin')){
        //     let removeUsersFromGroup = await db.User.updateMany({ companyId, groups: { $in: [group._id] }, deletedAt: null},{
        //         $pull: { groups: group._id }
        //     })
        //     await db.User.updateMany({companyId, groups:{$nin:groupsOfCompanyWithEmailAccess}},{$set:{isActive:false}})
        //     await db.User.updateMany({companyId, groups:{$nin:groupsOfCompanyWithMessengerAccess}},{$set:{isActiveMessenger:false}})

        //     await db.Group.deleteOne({_id: groupId, companyId})
        // }

        const groupsWithAccess = await db.Group.find({
            companyId, 
            deletedAt: null, 
            $or: [
                { emailAccess: true },
                { messengerAccess: true }
            ]
        }).select('_id emailAccess messengerAccess');

        let groupsWithEmailAccess = new Set();
        let groupsWithMessengerAccess = new Set();

        // Separating groups by access type
        groupsWithAccess.forEach(group => {
            if (group.emailAccess) groupsWithEmailAccess.add(group._id.toString());
            if (group.messengerAccess) groupsWithMessengerAccess.add(group._id.toString());
        });

        if ((isTacEnabled && group.type === "Custom") || (!isTacEnabled && group.type === 'Admin')) {
            await db.User.updateMany(
                { 
                    companyId, 
                    groups: group._id, 
                    deletedAt: null 
                },
                { 
                    $pull: { groups: group._id } 
                }
            );

            await db.User.updateMany(
                {
                    companyId,
                    deletedAt: null,
                    groups: { $nin: Array.from(groupsWithEmailAccess) } 
                },
                { $set: { isActive: false } }
            );
            
            await db.User.updateMany(
                {
                    companyId,
                    deletedAt: null,
                    groups: { $nin: Array.from(groupsWithMessengerAccess) } 
                },
                { $set: { isActiveMessenger: false } }
            );
            

            await db.Group.deleteOne({ _id: group._id, companyId });
        }

        return res.status(200).send({ success: true, message: "Group successfully removed!" })
    } catch (error) {
        console.log('error', error);
        next(error)
    }
}

const apiRouter = express.Router();
apiRouter.route('/').post(jwtStrategy,
//  checkTaConnectionStrategy,
 permission('Users','Read'),
 validateBody(validator), 
 controller);
export default apiRouter;