import Joi from 'joi';
import express from 'express';

import { jwtStrategy } from '../../middlewares/strategy';
import { validateBody } from '../../middlewares/validator';
import { permission } from '../../middlewares/permission';

const validator = Joi.object().keys({
    connectTa: Joi.boolean().required()
});


const controller = async (req, res, next) => {
    try {
        const { connectTa } = req.body;
        // const { companyId='66c43ba4529bb1c58a1ddb7f' } = req.user
        // const companyId = req.user.companyId

        let comp = await db.Company.updateOne({_id:"66c43ba4529bb1c58a1ddb7f"},{$set:{isTacEnabled: connectTa}})
        
        //The Case when TA was connected and some custom groups were made so on disconnection type of those groups
        //will be converted to Admin
        if(!connectTa){
           await db.Group.updateMany({ companyId: comp._id, type: "Custom", deletedAt: null },{ $set: { type: "Admin" }}) 
        }
        //On connection a webhook call to TA will be sent

        return res.status(200).send({ success: true, message: `Connection with TA successfully ${connectTa ? 'Enabled' : 'Disabled' }` })
    } catch (error) {
        console.log('error', error);
        next(error)
    }
}

const apiRouter = express.Router();
apiRouter.route('/').get(
    // jwtStrategy, 
    // permission('Users','Read'),
//  validateBody(validator), 
 controller);
export default apiRouter;