import express from 'express';

import { jwtStrategy } from '../../middlewares/strategy';
import { permission } from '../../middlewares/permission';



const controller = async (req, res, next) => {
    try {
        const { groupId } = req.body;
        const { companyId } = req.user

        const count = await db.User.countDocuments({groups:{$in: [groupId]}, deletedAt: null});
        let group = await db.Group.findOne({_id: groupId, companyId}).lean();
        let groupUsers = await db.User.find({groups:{$in:[groupId]}, deletedAt: null});
           
        res.status(200).json({ success: true, group, count, groupUsers });
    } catch (err) {
        console.log(err);
        next(err)
    }
}

const apiRouter = express.Router();
apiRouter.route('/').post(jwtStrategy, permission('IAM','Read'), controller);
export default apiRouter;