import Joi from 'joi';
import express from 'express';

import { jwtStrategy } from '../../middlewares/strategy';
import { validateBody } from '../../middlewares/validator';
import { permission } from '../../middlewares/permission';

const validator = Joi.object().keys({
    status: Joi.boolean().required(),
    accessType: Joi.string().required(),
    groupId: Joi.string().hex().length(24).required()
})


const controller = async (req, res, next) => {
    try {
        const { accessType, groupId, status } = req.body;
        const { companyId } = req.user

        const group = await db.Group.findOne({_id: groupId, companyId, deletedAt: null})
        if(!group) throw new RequestError("Group not found",404)

        if(accessType == "email"){
            if(!status){
                let activeGroupsOfCompany = await db.Group.find({companyId, deletedAt:null, emailAccess:true}).select("_id")
                
                let usersCountInGroup = await db.User.countDocuments({companyId, deletedAt:null, groups:{$in:[groupId]}}) 
                console.log({usersCountInGroup})
                let userLimit = (await db.MetaData.findOne({name:"userLimit", deletedAt:null, companyId})).value
                console.log({userLimit})

                let userCountForGroupsWhichHaveEmailAccess = 0;

                if(activeGroupsOfCompany.length > 0) userCountForGroupsWhichHaveEmailAccess = await db.User.countDocuments({companyId, deletedAt:null, groups:{$in:activeGroupsOfCompany}}) 
                console.log({userCountForGroupsWhichHaveEmailAccess})

                let remainingLimit = Math.max(0,userLimit - userCountForGroupsWhichHaveEmailAccess)
                console.log({remainingLimit})

                let userIds = await db.User.find({companyId, deletedAt:null, groups:{ $in: [groupId]}}).select('_id')
                console.log({userIds})

                let countOfUserswhichAlreadyBelongToGroupWithEmailAccess = 0;

                if(activeGroupsOfCompany.length > 0) countOfUserswhichAlreadyBelongToGroupWithEmailAccess = await db.User.countDocuments({_id:{$in:userIds}, companyId, deletedAt:null, groups:{$in:activeGroupsOfCompany}}) 
                console.log({countOfUserswhichAlreadyBelongToGroupWithEmailAccess})

                let countOfNewUsersThatNeedToBeAdded = Math.max(0,usersCountInGroup - countOfUserswhichAlreadyBelongToGroupWithEmailAccess)
                console.log({countOfNewUsersThatNeedToBeAdded})

                if(countOfNewUsersThatNeedToBeAdded > remainingLimit) throw new RequestError("User Limit Exceeded!")
                else{
                    await db.Group.updateOne({ _id: groupId, companyId},{$set:{emailAccess: !status}})
                    await db.User.updateMany({groups: {$in: [groupId] }, companyId, deletedAt:null},{$set:{isActive:true}})
                }
            }
            else{
                await db.Group.updateOne({ _id: groupId, companyId},{$set:{emailAccess: !status}})
                let activeGroupsOfCompany = await db.Group.find({companyId, deletedAt:null, emailAccess:true}).select("_id")
                if(activeGroupsOfCompany.length) await db.User.updateMany({groups: {$nin: activeGroupsOfCompany }, companyId, deletedAt:null},{$set:{isActive: false}})
                else await db.User.updateMany({ companyId, deletedAt:null},{$set:{isActive: false}})
            }
        }
        else{
            if(!status){
                let activeGroupsOfCompany = await db.Group.find({companyId, deletedAt:null, messengerAccess:true}).select("_id")
                console.log({activeGroupsOfCompany})
                
                let usersCountInGroup = await db.User.countDocuments({companyId, deletedAt:null, groups:{$in:[groupId]}}) 
                
                let userLimit = (await db.MetaData.findOne({name:"userLimitMessenger", companyId, deletedAt:null})).value
                
                let userCountForGroupsWhichHaveMessengerAccess = 0;
                if(activeGroupsOfCompany.length > 0) userCountForGroupsWhichHaveMessengerAccess = await db.User.countDocuments({companyId, deletedAt:null, groups:{$in:activeGroupsOfCompany}}) 
                
                let remainingLimit = Math.max(0,userLimit - userCountForGroupsWhichHaveMessengerAccess)

                let userIds = await db.User.find({companyId, deletedAt:null, groups:{ $in: groupId}}).select('_id')

                let countOfUserswhichAlreadyBelongToGroupWithMessengerAccess = 0;
                if(activeGroupsOfCompany.length > 0) countOfUserswhichAlreadyBelongToGroupWithMessengerAccess = await db.User.countDocuments({_id:{$in:userIds}, companyId, deletedAt:null,groups:{$in:activeGroupsOfCompany}}) 

                let countOfNewUsersThatNeedToBeAdded = Math.max(0,usersCountInGroup - countOfUserswhichAlreadyBelongToGroupWithMessengerAccess)
                console.log({countOfNewUsersThatNeedToBeAdded, remainingLimit})
                if(countOfNewUsersThatNeedToBeAdded > remainingLimit) throw new RequestError("User Limit Exceeded!")
                else{
                    await db.Group.updateOne({ _id: groupId, companyId},{$set:{messengerAccess: !status}})
                    await db.User.updateMany({groups: {$in: groupId }, companyId, deletedAt:null},{$set:{isActiveMessenger:true}})
                }
            }
            else{
                await db.Group.updateOne({ _id: groupId, companyId},{$set:{messengerAccess: !status}})
                let activeGroupsOfCompany = await db.Group.find({companyId, deletedAt:null, messengerAccess:true}).select("_id")
                if(activeGroupsOfCompany.length) await db.User.updateMany({groups: {$nin: activeGroupsOfCompany }, companyId, deletedAt:null},{$set:{isActiveMessenger: false}})
                else await db.User.updateMany({ companyId, deletedAt:null},{$set:{isActiveMessenger: false}})
            }
        }

        return res.status(200).send({ success: true, message: `Access for ${accessType} reporting for ${group.groupName} group has been successfully ${!status ? 'enabled' : 'disabled' }!` })
    } catch (error) {
        console.log('error', error);
        next(error)
    }
}

const apiRouter = express.Router();
apiRouter.route('/').post( 
 jwtStrategy,
 permission('Users','Write'),
 validateBody(validator), 
 controller);
export default apiRouter;