import express from 'express';

import { jwtStrategy } from '../../middlewares/strategy';
import { permission } from '../../middlewares/permission';


const controller = async (req, res, next) => {
    try {
        const { search, page, limit=10 } = req.body
        const companyId = req.user.companyId;
        const isTacEnabled = (await db.Company.findOne({_id: companyId, deletedAt: null})).isTacEnabled
        let condition = { companyId, deletedAt: null, type: 'Admin' };


        if(search && search.length){
            const regex = new RegExp(search, "i");
            condition['$or'] = [
                { groupName: regex }
            ]
        }
        

        let groups = await db.Group.find(condition)
        .lean()
        .skip((page-1)*limit)
        .limit(limit)


        let customGroups = [];
        if(isTacEnabled){
            customGroups = await db.Group.find({...condition, type: "Custom"})
            .lean()
            .skip((page-1)*limit)
            .limit(limit)
        }

        let groupsWithUserCount = await Promise.all(groups.map(async (group)=>{
            const userCount = await db.User.countDocuments({companyId, groups: {$in: [group._id] }, deletedAt: null})
            return {...group, userCount}
        }))

        if(customGroups.length){
            var customGroupsWithUserCount = await Promise.all(customGroups.map(async (group)=>{
                const userCount = await db.User.countDocuments({companyId, groups: {$in: [group._id] }, deletedAt: null})
                return {...group, userCount}
            }))
        }

        let adminGroupsCount = await db.Group.countDocuments(condition)
        let customGroupsCount = await db.Group.countDocuments({...condition, type: "Custom"})

        const allSyncingFalse = groupsWithUserCount.every(group => group.isSyncingUsers == false);
        const isLastSyncIdMismatchInAnyGroup = groupsWithUserCount.some(group => group.lastSyncIdMismatch === true);


        const showRetrySyncing = allSyncingFalse && isLastSyncIdMismatchInAnyGroup;
        let showSyncingInProgress = false
        if(groupsWithUserCount.length) showSyncingInProgress = groupsWithUserCount.every(group => group.isSyncingUsers == true)

        groupsWithUserCount = groupsWithUserCount?.filter(group => group.groupName !== 'Individual-Users');
        customGroupsWithUserCount = customGroupsWithUserCount?.filter(group => group.groupName !== 'Individual-Users');
    

        res.status(200).json({ success: true, adminGroups: groupsWithUserCount, customGroups: customGroupsWithUserCount ? customGroupsWithUserCount : [], adminGroupsCount, customGroupsCount, showRetrySyncing, showSyncingInProgress });
    } catch (err) {
        console.log(err);
        next(err)
    }
}

const apiRouter = express.Router();
apiRouter.route('/').post(jwtStrategy, permission('IAM','Read'), controller);
export default apiRouter;