import Joi from 'joi';
import express from 'express';
import mongoose from 'mongoose';

import { checkTaConnectionStrategy, jwtStrategy } from '../../middlewares/strategy';
import { validateBody } from '../../middlewares/validator';
import { permission } from '../../middlewares/permission';


const validator = Joi.object().keys({
    page: Joi.number().min(0).required(),
    limit: Joi.number().min(1).required(),
    domains: Joi.array().optional(),
    group: Joi.string().optional(),
    subDomainGroups: Joi.array().optional(),
    search: Joi.string().optional().allow(null).empty(''),
    status: Joi.string().optional().allow(null).empty(''),
});


const controller = async (req, res, next) => {
    const { userId, groupId } = req.body;
    const { companyId } = req.user;

    try {
        let group = await db.Group.findOne({ _id: groupId, companyId });
        if (!group) throw new RequestError("Group not found!");

        let user = await db.User.findOne({ _id: userId, companyId });
        if (!user) throw new RequestError("User not found!");

        const updatedUser = await db.User.findOneAndUpdate(
            { _id: userId },
            { $pull: { groups: mongoose.Types.ObjectId(groupId) } },
            { new: true }
        );

        if (!updatedUser) throw new RequestError("User not updated!");

        // Fetch active groups with email/messenger access
        let activeGroupsOfCompanyWithEmailAccess = await db.Group.find({
            companyId,
            deletedAt: null,
            emailAccess: true,
        }).select("_id");

        let activeGroupsOfCompanyWithMessengerAccess = await db.Group.find({
            companyId,
            deletedAt: null,
            messengerAccess: true,
        }).select("_id");

        // Map IDs to strings for comparison
        const emailGroupIds = activeGroupsOfCompanyWithEmailAccess.map(group => group._id.toString());
        const messengerGroupIds = activeGroupsOfCompanyWithMessengerAccess.map(group => group._id.toString());
        const userGroupIds = updatedUser.groups.map(groupId => groupId.toString());

        console.log({userGroupIds})

        // Check and update user's email and messenger activity status
        if (emailGroupIds.length > 0 && !emailGroupIds.some(groupId => userGroupIds.includes(groupId))) {
            await db.User.updateOne({ _id: userId, companyId }, { $set: { isActive: false } });
        }

        if (messengerGroupIds.length > 0 && !messengerGroupIds.some(groupId => userGroupIds.includes(groupId))) {
            await db.User.updateOne({ _id: userId, companyId }, { $set: { isActiveMessenger: false } });
        }

        // Count users in the group and delete if none
        const countUsersInCurrentGroup = await db.User.countDocuments({
            companyId,
            deletedAt: null,
            groups: { $in: [groupId] },
        });

        // if (!countUsersInCurrentGroup) {
        //     await db.Group.deleteOne({ _id: groupId, companyId });
        // }

        res.status(200).send({ message: "User and group updated successfully!" , areThereUsersInCurrentGroup: countUsersInCurrentGroup != 0});
    } catch (error) {
        console.error(error);
        next(error);
    }

    }

const apiRouter = express.Router();
apiRouter.route('/').post(jwtStrategy, 
    // checkTaConnectionStrategy, 
    permission('Users','Read'),
//  validateBody(validator), 
 controller);
export default apiRouter;