import Joi from 'joi';
import express from 'express';

import hackRecord from '../../service/hack-record';
import { validateBody } from '../../middlewares/validator';

let validator = Joi.object().keys({
	email: Joi.string().email().required()
});

/**
 * @api {post} /api/v1/hack-record/get get
 * @apiName get-hackrecord
 * @apiGroup Hack Record
 * @apiDescription Get hack records
 * 
 * @apiVersion 1.0.0
 * 
 * @apiBody   {String}  email   Required Email whose hack records are to be fetched 
 * 
 * @apiSuccess {Boolean} Success    true
 * @apiSuccess {String}  message    []
 * 
 * @apiSuccessExample Success-Response:
 *     HTTP/1.1 200 OK
 *       {
 *           "success": true,
 *           "results": "[]"
 *       }
 *  
 *  @apiError (500)  {Boolean}  success    false
 *  @apiError (500)  {Array}    results    []
 * 
 *  @apiErrorExample Error-Response:
 *     HTTP/1.1 500 Not Found
 *      {
 *          "success": false,
 *          "messages": [
 *              "Request failed with status code 500"
 *          ]
 *      }
 */

let controller = async (req, res, next) => {
    const { email } = req.body;
    hackRecord.getHackRecord(email)
    .then(results => {
        res.status(200).json({ succees: true, results: results.data })
    })
    .catch(err => {
        console.log(err);
        next(err);
    })
}

const apiRouter = express.Router();
apiRouter.route('/').post(validateBody(validator), controller);
export default apiRouter;