import Joi from 'joi';
import express from 'express';

import { sanitize } from '../../middlewares/sanitizer';
import { validateBody } from '../../middlewares/validator';
import { htmlsanitize } from '../../middlewares/sanitizeHtml';

let validator = Joi.object().keys({
    status: Joi.boolean().required(),
    licenceKey: Joi.string().required(),
    domainId: Joi.string().hex().length(24).required()
});

let controller = async (req, res, next) => {
    try {
        const { licenceKey, domainId, status = false } = req.body;
        const company = await db.Company.findOne({
            licenceKey
        })
        if(!company){
            throw new RequestError('invalid licence key or not find any company from this licence key')
        }

        const domain = await db.Domain.findOne({
            _id: domainId
        })

        if(!domain){
            throw new RequestError('invalid domainId recieved')
        }

        domain.set({
            'isVerified': status
        })
        domain.save();

        res.status(200).json({ success: true, message: 'domain status changed successfully' });

    } catch (err) {
        console.log(err);
        next(err)
    }
}

const apiRouter = express.Router();
apiRouter.route('/').post(htmlsanitize(), validateBody(validator), controller);
export default apiRouter;