import express from 'express';

import { sanitize } from '../../middlewares/sanitizer';
import { htmlsanitize } from '../../middlewares/sanitizeHtml';

let controller = async (req, res, next) => {
    try {
        const { licenceKey } = req.params;
        const company = await db.Company.findOne({
            licenceKey
        })
        if(!company){
            throw new RequestError('invalid licence key or not find any company from this licence key')
        }

        const domains = await db.Domain.find({
            companyId: company._id,
            deletedAt: null
        })
        
        res.status(200).json({ success: true, domains });
    } catch (err) {
        console.log(err);
        next(err)
    }
}

const apiRouter = express.Router();
apiRouter.route('/:licenceKey').get(htmlsanitize(), controller);
export default apiRouter;