import Joi from 'joi';
import express from 'express';

import { sanitize } from '../../middlewares/sanitizer';
import { validateBody } from '../../middlewares/validator';
import { htmlsanitize } from '../../middlewares/sanitizeHtml';

let validator = Joi.object().keys({
    userLimit: Joi.number().required(),
    domainLimit: Joi.number().required(),
    expiredAt: Joi.date().iso().required(),
    licenceKey: Joi.string().required(),
});

let changeActiveStatus = async (companyId) => {
    try {
        const userLimit = (await db.MetaData.findOne({ companyId, name: "userLimit" })).value;
        const activatedUsersCount = await db.User.countDocuments({ companyId, deletedAt: null, isActive: true });
        if (activatedUsersCount > userLimit) {
            const count = activatedUsersCount - userLimit
            const user = await db.User.find({ companyId, isActive: true, deletedAt:null }).sort({ createdAt: -1 }).limit(count)
            for (let i = 0; i < user.length; i++) {
                user[i].isActive = false
                await user[i].save()
            }
        }
    } catch (error) {
        console.log(error);
    } finally {
        return ;
    }
}
let controller = async (req, res, next) => {
    try {
        const { licenceKey, userLimit, domainLimit, expiredAt } = req.body;
        const company = await db.Company.findOne({
            licenceKey
        })
        if(!company){
            throw new RequestError('invalid licence key or not find any company from this licence key')
        }
        const companyId = company._id;

        const metadataUser = await db.MetaData.findOne({
            companyId,
            name: 'userLimit'
        })

        if(metadataUser){
            metadataUser.set({
                value: userLimit
            })
            await metadataUser.save();
            await changeActiveStatus(companyId)
        } else {
            await db.MetaData.create({
                companyId, 
                name: 'userLimit', 
                value: userLimit
            })
        }

        const metadataDomain = await db.MetaData.findOne({
            companyId,
            name: 'domainLimit'
        })

        if(metadataDomain){
            metadataDomain.set({
                value: domainLimit
            })
            await metadataDomain.save();
        } else {
            await db.MetaData.create({
                companyId, 
                name: 'domainLimit', 
                value: domainLimit
            })
        }

        const metadataExpiretAt = await db.MetaData.findOne({
            companyId,
            name: 'expiredAt'
        })

        if(metadataExpiretAt){
            metadataExpiretAt.set({
                value: new Date(expiredAt)
            })
            await metadataExpiretAt.save();
        } else {
            await db.MetaData.create({
                companyId, 
                name: 'expiredAt', 
                value: new Date(expiredAt)
            })
        }

        res.status(200).json({ success: true, message: 'licence updated successfully' });

    } catch (err) {
        console.log(err);
        next(err)
    }
}

const apiRouter = express.Router();
apiRouter.route('/').post(htmlsanitize() , validateBody(validator), controller);
export default apiRouter;