import express from 'express';

import { sanitize } from '../../middlewares/sanitizer';
import { jwtStrategy } from '../../middlewares/strategy';
import { licenceCheck } from '../../service/licence-check';

let controller = async (req, res, next) => {
    try {
        let user = 0, domain = 0, expiry = new Date(), messenger = 0;

        const companyId = req.user.companyId;
        const userLimit = await db.MetaData.findOne({
            companyId,
            name: 'userLimit'
        })
        const userLimitMessenger = await db.MetaData.findOne({
            companyId,
            name: 'userLimitMessenger'
        })
        const domainLimit = await db.MetaData.findOne({
            companyId,
            name: 'domainLimit'
        })
        const expiredAt = await db.MetaData.findOne({
            companyId,
            name: 'expiredAt'
        })

        const addedUsersCount = await db.User.countDocuments({companyId, deletedAt:null})
        const remainingUserLimit = (parseInt(userLimit?.value) + parseInt(userLimitMessenger?.value)) - addedUsersCount

        let userCountForGroupsWhichHaveEmailAccess = 0
        let activeGroupsOfCompanyForEmail = await db.Group.find({companyId, deletedAt:null, emailAccess:true}).select("_id")
        if(activeGroupsOfCompanyForEmail.length > 0) userCountForGroupsWhichHaveEmailAccess = await db.User.countDocuments({companyId, deletedAt:null, groups:{$in:activeGroupsOfCompanyForEmail.map(group=>group._id)}}) 

        let userCountForGroupsWhichHaveMessengerAccess = 0
        let activeGroupsOfCompanyForMessenger = await db.Group.find({companyId, deletedAt:null, messengerAccess:true}).select("_id")
        if(activeGroupsOfCompanyForMessenger.length > 0) userCountForGroupsWhichHaveMessengerAccess = await db.User.countDocuments({companyId, deletedAt:null, groups:{$in:activeGroupsOfCompanyForMessenger.map(group=>group._id)}})


        if(userLimit && userLimitMessenger &&  domainLimit && expiredAt){
            user = userLimit.value
            domain = domainLimit.value
            messenger =  userLimitMessenger.value
            expiry = new Date(expiredAt.value)
        } 
        console.log({
            user, domain, messenger, expiry
        })
        // else {
        //     const company = await db.Company.findOne({
        //         _id: companyId
        //     })
        //     let license = {
        //         user: "10",
        //         domain: "1",
        //         expiry: 
        //     }

        //     user = license.userLimit
        //     domain = license.domainLimit
        //     expiry = license.expiresAt
        //     await db.MetaData.create({
        //         companyId, 
        //         name: 'userLimit', 
        //         value: "10"
        //     })
        //     await db.MetaData.create({
        //         companyId, 
        //         name: 'domainLimit', 
        //         value: "1"
        //     })
        //     await db.MetaData.create({
        //         companyId, 
        //         name: 'expiredAt', 
        //         value: new Date(new Date(date).setDate(new Date(date).getDate()+14))
        //     })
        // }

        if(!expiry) expiry = new Date(new Date(companyId.createdAt).setDate(new Date(companyId.createdAt).getDate()+14));
        

        res.status(200).json({ success: true, user: parseInt(user), messenger: parseInt(messenger), expiry, utilisedEmailLimit: userCountForGroupsWhichHaveEmailAccess, utilisedMessengerLimit: userCountForGroupsWhichHaveMessengerAccess, remainingUserLimit });
    } catch(err){
        console.log(err);
        next(err);
    }
}
const apiRouter = express.Router();
apiRouter.route('/').get(sanitize(), jwtStrategy, controller);
export default apiRouter;