import express from "express";

import { sanitize } from "../../middlewares/sanitizer";
import { jwtStrategy } from "../../middlewares/strategy";

const controller = async (req, res, next) => {
  try {
    const companyId = req.user.companyId;

    let domainsOfCurrentCompany = await db.Domain.find({
      companyId,
      deletedAt: null,
    }).select("domainType domainTypeForOutlook");

    let uniqueDomains = new Set();
    domainsOfCurrentCompany.map((currentDomain) => {
      uniqueDomains.add(currentDomain._id);
    });

    let namesOfdomains = [];

    domainsOfCurrentCompany.map((value) => {
      if (value.domainType === "Gsuite") {
        namesOfdomains.push("Gsuite");
      } else {
        namesOfdomains.push("Outlook");
        namesOfdomains.push(
          value.domainTypeForOutlook === "EXCHANGE"
            ? "Exchange"
            : value.domainTypeForOutlook
        );
      }
    });

    domainsOfCurrentCompany = [...uniqueDomains];

    let uniqueDomainNames = new Set();
    namesOfdomains.map((value) => {
      console.log(value);
      uniqueDomainNames.add(value);
    });

    namesOfdomains = [...uniqueDomainNames];

    domainsOfCurrentCompany = domainsOfCurrentCompany.map((value) => {
      return value._id;
    });

    const reportedEmails = await db.ReportedMail.countDocuments({
      companyId,
      domainId: { $in: domainsOfCurrentCompany },
      mailType: { $in: namesOfdomains },
    });
    const domains = await db.Domain.countDocuments({
      companyId,
      deletedAt: null,
    });
    const emailChecked = await db.CheckEmailScoreEvent.countDocuments({
      companyId,
    });
    const users = await db.User.countDocuments({
      companyId,
      email: { $ne: null },
      deletedAt: null,
      isActive: true,
    });

    const contacts = await db.User.countDocuments({
      companyId,
      phoneNumber: { $ne: null },
      deletedAt: null,
    });

    const whatsappReportings = await db.whatsapp.countDocuments({
      companyId,
      deletedAt: null,
    });

    return res.status(200).send({
      success: true,
      reportedEmails,
      domains,
      emailChecked,
      users,
      whatsappReportings,
      contacts
    });
  } catch (error) {
    console.log("error", error);
    next(error);
  }
};

const apiRouter = express.Router();
apiRouter.route("/").get(sanitize(), jwtStrategy, controller);
export default apiRouter;
