import express from 'express';

import { sanitize } from '../../middlewares/sanitizer';
import { jwtStrategy } from '../../middlewares/strategy';
import getGraphData from '../../service/dashboardHelper';

/**
 * @api {post} /api/overview/daily-reported daily-reported
 * @apiName daily-reported
 * @apiGroup overview
 * @apiDescription list of reported mails of last 7 days
 * 
 * @apiVersion 1.0.0
 * 
 * @apiSuccessExample Success-Response:
 *      HTTP/1.1 200 OK 
 * 
 *  {
 *      "success":true,
 *      "reportedEmails":[ 
 *          {"count":5,"date":"2023-02-14"},
 *          {"count":24,"date":"2023-02-10"}]
 * }
 *
 */

let controller = async (req, res, next) => {
    try {
        const companyId = req.user.companyId;
        
        const result = await getGraphData("RETPIR6", { companyId })
        
        res.status(200).json({ success: true, result: result?.data });
    } catch(err){
        console.log(err);
        next(err);
    }
}
const apiRouter = express.Router();
apiRouter.route('/').get(sanitize(), jwtStrategy, controller);
export default apiRouter;