import express from 'express';

import { sanitize } from '../../middlewares/sanitizer';
import { jwtStrategy } from '../../middlewares/strategy';
import getGraphData from '../../service/dashboardHelper';


let controller = async (req, res, next) => {
    try {
        const companyId = req.user.companyId;

        const reportedMails = await getGraphData("RETPIR2", { companyId })

        res.status(200).json({ success: true, reportedMails: reportedMails?.data });
    } catch(err){
        console.log(err);
        next(err);
    }
}
const apiRouter = express.Router();
apiRouter.route('/').get(sanitize(), jwtStrategy, controller);
export default apiRouter;