import express from 'express';

import { sanitize } from '../../middlewares/sanitizer';
import { jwtStrategy } from '../../middlewares/strategy';

/**
 * @api {post} /api/overview/recent-reported recent-reported
 * @apiName recent-reported
 * @apiGroup overview
 * @apiDescription list of 5 most recent reported mails 
 * 
 * @apiVersion 1.0.0
 * 
 * @apiSuccessExample Success-Response:
 *      HTTP/1.1 200 OK 
 * 
 *    { 
 *      "success":true,
 *      "reportedEmails":[
 *      {"_id":"63ebd30e5463e78fb1064a09","from":"awareness@kratikal.com","subject":"Your Mail has been successfully Reported"},
 *      {"_id":"63ebd2ea5463e78fb10649ec","from":"himanshu.bisht@kratikal.com","subject":"Buddy Assign"},
 *      {"_id":"63ebce8b081d559ace566d0f","from":"mnnitsarvesh@outlook.com","subject":"Feedback Experience"},
 *      {"_id":"63ebce66081d559ace566cfb","from":"himanshu.bisht@kratikal.com","subject":"New sign - in from Zoho account"},
 *      {"_id":"63ebce44081d559ace566cd8","from":"awareness@kratikal.com","subject":"Your Mail has been successfully Reported"}]
 *    }
 *
 */

let controller = async (req, res, next) => {
    try {
        const companyId = req.user.companyId;
        let condition = {
            companyId,
            deletedAt: null,
        }
        const reportedEmails = await db.ReportedMail.find(condition)
        .select('from subject ')
        .sort({'createdAt': -1})
        .limit(5);
        res.status(200).json({ success: true, reportedEmails });
    } catch(err){
        console.log(err);
        next(err);
    }
}
const apiRouter = express.Router();
apiRouter.route('/').get(sanitize(), jwtStrategy, controller);
export default apiRouter;