import express from 'express';

import { sanitize } from '../../middlewares/sanitizer';
import { jwtStrategy } from '../../middlewares/strategy';

let controller = async (req, res, next) => {
    try {
        const companyId = req.user.companyId;
        let condition = {
            companyId,
            deletedAt: null,
        }
        const whatsappReported = await db.whatsapp.find(condition)
        .select('from phoneNumber')
        .sort({'createdAt': -1})
        .limit(5);
        res.status(200).json({ success: true, whatsappReported });
    } catch(err){
        console.log(err);
        next(err);
    }
}
const apiRouter = express.Router();
apiRouter.route('/').get(sanitize(), jwtStrategy, controller);
export default apiRouter;