import express from 'express';

import { sanitize } from '../../middlewares/sanitizer';
import { jwtStrategy } from '../../middlewares/strategy';
import getGraphData from '../../service/dashboardHelper';

/**
 * @api {post} /api/overview/top-reporters top-reporters
 * @apiName top-reporters
 * @apiGroup overview
 * @apiDescription list of 5 most top reporters  
 * 
 * @apiVersion 1.0.0
 * 
 * @apiSuccessExample Success-Response:
 *      HTTP/1.1 200 OK 
 * 
 *     { 
 *       "success":true,
 *       "reportedEmails":[
 *          {"_id":"arpit@kdmarc.com","count":24},
 *          {"_id":"gaurav@kdmarc.com","count":3},
 *          {"_id":"vikas@kdmarc.com","count":2}],
 *       "count":29
 *     }
 *
 */

let controller = async (req, res, next) => {
    try {
        const companyId = req.user.companyId;

        const result = await getGraphData("RETPIR5",{isDeletedEmail: "true", companyId })
          
        res.status(200).json({ success: true,  senders: result?.data });
    } catch(err){
        console.log(err);
        next(err);
    }
}
const apiRouter = express.Router();
apiRouter.route('/').get(sanitize(), jwtStrategy, controller);
export default apiRouter;