import express from "express";

import { sanitize } from "../../middlewares/sanitizer";
import { jwtStrategy } from "../../middlewares/strategy";
import getGraphData from "../../service/dashboardHelper";

const controller = async (req, res, next) => {
  try {
    const companyId = req.user.companyId;

    let condition = { companyId }
    let  topUrls = await getGraphData("RETPIR3", condition)
    console.log({topUrls})
    let  topAttachments = await getGraphData("RETPIR4", condition)

    return res.status(200).send({
      success: true,
      topAttachments: topAttachments?.data,
      topUrls: topUrls?.data,
    });
  } catch (error) {
    console.log("error", error);
    next(error);
  }
};

const apiRouter = express.Router();
apiRouter.route("/").get(sanitize(), jwtStrategy, controller);
export default apiRouter;
