import express from "express";

import { sanitize } from "../../middlewares/sanitizer";
import { jwtStrategy } from "../../middlewares/strategy";

let controller = async (req, res, next) => {
  try {
    const companyId = req.user.companyId;
    //HERE WE ARE SELCTING THE DOMAINS THAT ARE NOT DELETED AND FOR DOMAINTYPE = 'OUTLOOK' FOR GSUITE DOMAINTYPE STORED IN REPORTEDEMAILS SCHEMA IS 'Gsuite'
    //WE HAVE 2 OPTIONS '0FFICE365' AND 'EXCHANGE' FOR 'OFFICE365'  DOMAINTYPE = 'Outlook' and for
    //EXCHANGE IT IS 'Exchange'.
     // here two sets are for storing only unique domainType/domainType for outlook and domainId
    // cuz for two domains the domainType could be same but still they can have same domainType i.e Gsuite or Outlook 

    let domainsOfCurrentCompany = await db.Domain.find({
      companyId,
      deletedAt: null,
    }).select("domainType domainTypeForOutlook");

    let uniqueDomains = new Set();// for doamin id

    domainsOfCurrentCompany.map((currentDomain) => {
      uniqueDomains.add(currentDomain._id);
    });

    let namesOfdomains = [];

    domainsOfCurrentCompany.map((value) => {
      if (value.domainType === "Gsuite") {
        namesOfdomains.push("Gsuite");
      } else {
        namesOfdomains.push("Outlook");
        namesOfdomains.push(
          value.domainTypeForOutlook === "EXCHANGE"
            ? "Exchange"
            : value.domainTypeForOutlook
        );
      }
    });

    domainsOfCurrentCompany = [...uniqueDomains];

    let uniqueDomainNames = new Set(); // for domainType

    namesOfdomains.map((value) => {
      console.log(value);
      uniqueDomainNames.add(value);
    });

    namesOfdomains = [...uniqueDomainNames];

    domainsOfCurrentCompany = domainsOfCurrentCompany.map((value) => {
      return value._id;
    });
    
    const trashedMails = await db.ReportedMail.countDocuments({
      companyId,
      isRecoveredEmail: "false",
      isTrashedEmail: "true",
      isDeletedEmail: "false",
      domainId: { $in: domainsOfCurrentCompany },
      mailType: { $in: namesOfdomains },
    });
    const suspiciousMails = await db.ReportedMail.countDocuments({
      companyId,
      isRecoveredEmail: "false",
      isTrashedEmail: "false",
      isDeletedEmail: "true",
      domainId: { $in: domainsOfCurrentCompany },
      mailType: { $in: namesOfdomains },
    });
    const pendingMails = await db.ReportedMail.countDocuments({
      companyId,
      isRecoveredEmail: "false",
      isTrashedEmail: "false",
      isDeletedEmail: "false",
      domainId: { $in: domainsOfCurrentCompany },
      mailType: { $in: namesOfdomains },
    });
    const safeMails = await db.ReportedMail.countDocuments({
      companyId,
      isRecoveredEmail: "true",
      isTrashedEmail: "false",
      isDeletedEmail: "false",
      domainId: { $in: domainsOfCurrentCompany },
      mailType: { $in: namesOfdomains },
    });

    res
      .status(200)
      .json({
        success: true,
        trashedMails,
        suspiciousMails,
        pendingMails,
        safeMails,
      });
  } catch (err) {
    console.log(err);
    next(err);
  }
};
const apiRouter = express.Router();
apiRouter.route("/").get(sanitize(), jwtStrategy, controller);
export default apiRouter;
