import express from 'express';
import { jwtStrategy } from '../../middlewares/strategy';
import { htmlsanitize } from '../../middlewares/sanitizeHtml';
import JWT from 'jsonwebtoken';
import config from '../../config';
import { RequestError } from '../../errors';

const apiRouter = express.Router();

let controller = async (req, res, next) => {
  try {
    const token = req.cookies.login_token;
    if (!token) {
      throw new RequestError('Not authenticated', 401);
    }

    const payload = JWT.verify(token, config.app.secret);

    const features = Array.isArray(payload.AF) ? payload.AF : [];

    return res.status(200).json({
      success: true,
      features
    });
  } catch (error) {
    next(error);
  }
};

apiRouter
  .route('/')
  .get(
    htmlsanitize(),
    jwtStrategy,
    controller
  );

export default apiRouter;
