
import express from 'express';
import { checkCompanyValidityStrategy, jwtStrategy } from '../../middlewares/strategy';
import { htmlsanitize } from '../../middlewares/sanitizeHtml';
import packageHelper from '../../service/package-helper';
import JWT from 'jsonwebtoken';
import config from '../../config';


let JWTSign = function (iss, user, date, type, sudoPassword, companyFeatures) {
    return JWT.sign({
        iss: config.app.name + '-' + iss,
        sub: user._id,
        type: type,
        iat: date.getTime(),
        AF:companyFeatures,
        exp: new Date().setMinutes(date.getMinutes() + 600),
        sudoPassword: sudoPassword ? sudoPassword : false
    }, config.app.secret);
}

let generateToken = async (companyId, user) =>{
    let companyFeatures = await db.CompanyFeature.find({companyId}).select({_id:0, featureCode:1})
    companyFeatures = companyFeatures?.map(feature=>feature.featureCode)  
    let token = JWTSign('USER', user, new Date(), user.type, user.sudoPassword, companyFeatures);
    return token
}

let controller = async (req, res, next) => {
    try{
        const { companyId } = req.user

        const company = await db.Company.findById(companyId)
        if(!company) throw new RequestError("Company not found!",404)

        const syncPackage = await packageHelper.syncPackageDetails(company)
        var token = null
        console.log({syncPackage, company, change: company?.packageModifiedLocally})
        if(syncPackage){
            console.log("Existing package modified, updating token!")
            token = await generateToken(companyId, req.user)
        }
        else if(company?.packageModifiedLocally){
            console.log("New package assigned, updating token!")
            token = await generateToken(companyId, req.user)
            await db.Company.updateOne({_id: companyId},{$set: {packageModifiedLocally: false}})
        }

        if(token){
            res.cookie('login_token', token, {
                httpOnly: true,
                secure: true,   
                sameSite: 'Strict',
                maxAge: 180 * 60 * 1000
            });
        }

        return res.status(200).json({
            success: true
        })
    }catch(error){
        next(error)
    }
    }
const apiRouter = express.Router();
apiRouter.route('/').get(htmlsanitize(), jwtStrategy, checkCompanyValidityStrategy ,controller);
export default apiRouter;