import Joi from 'joi';
import express from 'express';

import { sanitize } from '../../middlewares/sanitizer';
import { jwtStrategy } from '../../middlewares/strategy';
import { validateBody } from '../../middlewares/validator';
import { permission } from '../../middlewares/permission';
import { htmlsanitize } from '../../middlewares/sanitizeHtml';

let validator = Joi.object().keys({
    employeeId: Joi.string().hex().length(24).required(),
});

/**
 * @api {get} /api/v1/policy/employee-policy?employeeId=63bbece26781cb50f1fa68ba  Policies of an IAM user
 * @apiName employee-policy
 * @apiGroup Policy
 * @apiDescription List policies of an IAM user
 * 
 * @apiQuery   {String}  employeeId   Required Id of the IAM emplyoee
 * 
 * @apiVersion 1.0.0
 * 
 * @apiSuccess {Boolean} success    true
 * @apiSuccess {String}  policies   list of all policies of an employee
 * 
 * @apiSuccessExample Success-Response:
 *     HTTP/1.1 200 OK
 *       {
 *           "success": true,
 *           "policies": [
 *               {
 *                   "_id": "63d0f1d278b9830aa47b3067",
 *                   "name": "Super User",
 *                   "value": [
 *                       "Read",
 *                       "Write",
 *                       "Delete"
 *                   ],
 *                   "createdAt": "2023-01-25T09:09:38.169Z",
 *                   "updatedAt": "2023-01-25T09:09:38.169Z",
 *                   "__v": 0
 *               },
 *               {
 *                   "_id": "63d0f1d278b9830aa47b306a",
 *                   "name": "Domain",
 *                   "value": [
 *                       "Read",
 *                       "Write",
 *                       "Delete"
 *                   ],
 *                   "createdAt": "2023-01-25T09:09:38.174Z",
 *                   "updatedAt": "2023-01-25T09:09:38.174Z",
 *                   "__v": 0
 *               },
 *           ]
 *       }
 *  
 *  @apiError (404)  {Boolean}  success     false
 *  @apiError (404)  {Array}    messages    Employee not Found
 * 
 *  @apiErrorExample Error-Response:
 *     HTTP/1.1 404 Not Found
 *      {
 *          "success": false,
 *          "messages": [
 *              "Employee not Found"
 *          ]
 *      }
 */

let controller = async (req, res, next) => {
    try {
        const { employeeId } = req.query;
        const policies = await db.EmployeePolicy.find({ employeeId });
        res.status(201).send({ success: true, policies })
    } catch (err) {
        console.log(err);
        next(err)
    }
}

const apiRouter = express.Router();
apiRouter.route('/').get(htmlsanitize(), jwtStrategy, permission('IAM','Read'), validateBody(validator), controller);
export default apiRouter;