import express from 'express';
import { permission } from '../../middlewares/permission';

import { sanitize } from '../../middlewares/sanitizer';
import { jwtStrategy } from '../../middlewares/strategy';

/**
 * @api {get} /api/v1/policy/list list
 * @apiName list
 * @apiGroup Policy
 * @apiDescription list of all policies 
 * 
 * @apiVersion 1.0.0
 * 
 * @apiSuccess {Boolean} success    true
 * @apiSuccess {String}  policies   list of all policies
 * 
 * @apiSuccessExample Success-Response:
 *     HTTP/1.1 200 OK
 *       {
 *   "success": true,
 *   "policies": [
 *       {
 *           "_id": "63d0ea0a032f943fc31e4e68",
 *           "name": "Super User",
 *           "__v": 0,
 *           "createdAt": "2023-01-25T08:36:26.114Z",
 *           "updatedAt": "2023-01-25T08:36:26.114Z"
 *       },
 *       {
 *           "_id": "63d0ea0a032f943fc31e4e69",
 *           "name": "Domain",
 *           "__v": 0,
 *           "createdAt": "2023-01-25T08:36:26.115Z",
 *           "updatedAt": "2023-01-25T08:36:26.115Z"
 *       },
 *       {
 *           "_id": "63d0ea0a032f943fc31e4e6a",
 *           "name": "Emails",
 *           "__v": 0,
 *           "createdAt": "2023-01-25T08:36:26.115Z",
 *           "updatedAt": "2023-01-25T08:36:26.115Z"
 *       },
 *       {
 *           "_id": "63d0ea0a032f943fc31e4e6b",
 *           "name": "Users",
 *           "__v": 0,
 *           "createdAt": "2023-01-25T08:36:26.116Z",
 *           "updatedAt": "2023-01-25T08:36:26.116Z"
 *       },
 *       {
 *           "_id": "63d0ea0a032f943fc31e4e6c",
 *           "name": "IAM",
 *           "__v": 0,
 *           "createdAt": "2023-01-25T08:36:26.117Z",
 *           "updatedAt": "2023-01-25T08:36:26.117Z"
 *       },
 *       {
 *           "_id": "63d0ea0a032f943fc31e4e6d",
 *           "name": "AdvancedSearch",
 *           "__v": 0,
 *           "createdAt": "2023-01-25T08:36:26.117Z",
 *           "updatedAt": "2023-01-25T08:36:26.117Z"
 *       }
 *   ]
 *}
 * 
 */


let controller = async (req, res, next) => {
    try {
        const policies = await db.Policy.find();
        res.status(201).send({ success: true, policies })
    } catch (err) {
        console.log(err);
        next(err)
    }
}

const apiRouter = express.Router();
apiRouter.route('/').get(sanitize(), jwtStrategy, permission('IAM','Read'), controller);
export default apiRouter;