import express from 'express'
import { htmlsanitize } from '../../middlewares/sanitizeHtml'
import { sanitize } from '../../middlewares/sanitizer'


const controller = async (req, res, next) => {
  console.log('Check Already Reported Email Outlook')
  try {
    const { internetMessageId, email } = req.body
    let mailFound = false
    let isSameReporter = false
    let reporters = 0
    let mailAction = 'Decision Pending'
    let mailResult = 'Awaited'
    let spamScore = 0

    const reportedMail = await db.ReportedMail.findOne({ internetMessageId })
    console.log('Internet Message ID:', internetMessageId)
    console.log('Reported Mail:', reportedMail)
    if (reportedMail) {
      mailFound = true
      reporters = reportedMail.reporters && reportedMail.reporters.length
        ? reportedMail.reporters.length
        : 0
      spamScore = reportedMail.spamScore || 0

      const me = email.toLowerCase()
      if (
        reportedMail.to &&
        reportedMail.to.toLowerCase() === me
      ) {
        isSameReporter = true
      } else if (
        reportedMail.reporters &&
        reportedMail.reporters.some(r => r.email.toLowerCase() === me)
      ) {
        isSameReporter = true
      }

      if (reportedMail.isDeletedEmail === 'true') {
        mailAction = 'Decision Taken'
        mailResult = 'Deleted'
      } else if (reportedMail.isTrashedEmail === 'true') {
        mailAction = 'Decision Taken'
        mailResult = 'Trashed'
      } else if (reportedMail.isRecoveredEmail === 'true') {
        mailAction = 'Decision Taken'
        mailResult = 'Recovered'
      }
    }
    console.log('Mail Found:', mailFound)
    res.status(200).send({
      mailFound,
      isSameReporter,
      reporters,
      mailAction,
      mailResult,
      spamScore
    })
  } catch (err) {
    console.error(err)
    next(err)
  }
}

const router = express.Router()
router.post(
  '/',
  /*htmlsanitize(),
  sanitize(),*/
  controller
)

export default router
