import Joi from 'joi';
import Spamc from 'spamc';
import express from 'express';

import config from '../../config';
import { queue } from '../../kue';
import parseHeader from '../../service/parse-header';
import getMailData from '../../service/get-mail-data';
import { sanitize } from '../../middlewares/sanitizer';
import { validateBody } from '../../middlewares/validator';
import { htmlsanitize } from '../../middlewares/sanitizeHtml';

const spamc = new Spamc(config.spamassession.host, config.spamassession.port, 10000);

// const validator = Joi.object().keys({
//     internetMessageId: Joi.string().required(),
//     email: Joi.string().email().required(),
//     emailType: Joi.string().optional(),
// });

/**
 * @api {post} /api/report/check-email check-email
 * @apiName Check Email
 * @apiGroup Report
 * @apiDescription check the email of the user
 * 
 * @apiVersion 1.0.0
 * 
 * @apiBody {String} messageId               Required message id of the mail.
 * @apiBody {String} accessToken             Required access token of the mailbox.
 *
 * @apiSuccess {Boolean} success             true
 * @apiSuccess {String}  headerDetails       header details of the message.
 * @apiSuccess {String}  result              spam result of the message.
 * 
 * @apiSuccessExample Success-Response:
 *     HTTP/1.1 404 Not Found
 *      {
 *          "success":          true,
 *          "result":           "Details updated successfully",
 *          "headerDetails"     []
 *      } 
 * 
 */

const controller = async (req, res, next) => {
    try {
        let { accessToken, messageId, email, internetMessageId, emailType } = req.body;

        email = email.toLowerCase();

        let reporters = 0;
        let action = ''
        let result = 'Awaited'
        let userFound = false;
        let mailFound = false;
        let spamScore = 0
        let isSameReporter = false
        
        const reportedMail = await db.ReportedMail.findOne({internetMessageId})
        if(reportedMail) {
            mailFound = true;
            reporters = reportedMail.reporters ? (reportedMail.reporters.length + 1) : 0;
            spamScore = reportedMail.spamScore
            if(reportedMail.to == email.toLowerCase()) isSameReporter = true;
            else if(reportedMail.reporters && reportedMail.reporters.length) reportedMail.reporters.some((reporter)=> reporter.email.toLowerCase() == email.toLowerCase() ) ? isSameReporter = true : ''
            if(reportedMail.isRecoveredEmail == 'true') { result = "Recovered", action="Decision Taken"}
            if(reportedMail.isTrashedEmail == 'true') { result = "Trashed", action="Decision Taken"}
            if(reportedMail.isDeletedEmail == 'true') { result = "Deleted",  action="Decision Taken"}
            if(isSameReporter && reportedMail.isTrashedEmail == 'false' && reportedMail.isDeletedEmail == 'false' && reportedMail.isRecoveredEmail == 'false') { result = "Awaited",  action="Decision Pending"}
        }

        let condition = {
            email: email,
            deletedAt: null
        }
        if(emailType){
            condition['emailType'] = emailType  
        }

        const user = await db.User.findOne(condition);
        console.log('user issss', user);
        if (user) {
        userFound = true;

        // Criteria: User is in the "to" field or listed as a reporter
        const userEmailCriteria = { 
            $or: [
            { to: email }, 
            { reporters: { $elemMatch: { email: email } } }
            ]
        };
        // const domainCriteria = { domainId: user.domainId, deletedAt: null };

        // Combining the criteria
        const combinedCriteria = { $and: [userEmailCriteria], companyId: user.companyId };


        const totalMails = await db.ReportedMail.countDocuments(combinedCriteria);

        // Criteria for deleted, trashed, recovered, and pending mails
        const deletedCriteria = { ...combinedCriteria, isDeletedEmail: "true", companyId: user.companyId };
        const trashedCriteria = { ...combinedCriteria, isTrashedEmail: "true", companyId: user.companyId };
        const recoveredCriteria = { ...combinedCriteria, isRecoveredEmail: "true", companyId: user.companyId };
        const pendingCriteria = {
            ...combinedCriteria,
            isDeletedEmail: "false",
            isTrashedEmail: "false",
            isRecoveredEmail: "false",
            companyId: user.companyId
        };

        const deletedMails = await db.ReportedMail.countDocuments(deletedCriteria);
        const trashedMails = await db.ReportedMail.countDocuments(trashedCriteria);
        const recoveredMails = await db.ReportedMail.countDocuments(recoveredCriteria);
        const pendingMails = await db.ReportedMail.countDocuments(pendingCriteria);

        var userStats = {
            totalMails,
            deletedMails,
            trashedMails,
            recoveredMails,
            pendingMails,
        };

        console.log('User stats:', userStats);
        }
     return res.status(200).send({userStats, reporters, result, action, userFound, mailFound, spamScore, isSameReporter })
    } catch(err){
        console.log(err);
        next(err);
    }
}
const apiRouter = express.Router();
apiRouter.route('/').post(
    // validateBody(validator), 
    controller);
export default apiRouter;