import Joi from 'joi';
import express from 'express';
import { sanitize } from '../../middlewares/sanitizer';
import { validateBody } from '../../middlewares/validator';
import { htmlsanitize } from '../../middlewares/sanitizeHtml';

// const validator = Joi.object().keys({
//   email: Joi.string().email().required(),
//   name: Joi.string().optional().allow(null),
//   type: Joi.any().valid('Outlook', 'Gsuite', 'Exchange').required(),
// });

const controller = async (req, res, next) => {
  try {
    let { email, type, name } = req.body;

    email = email.toLowerCase()
    var domainFromEmail = ''

    const match = email.split('@')[1];
    console.log(match)
    
    if (match) {
      domainFromEmail = match;
    } else {
      console.log("No match found");
      throw new RequestError('Email Not Found!')
    }
    console.log(domainFromEmail)

    let domain = await db.Domain.findOne({ domainName: domainFromEmail, deletedAt: null });
    console.log({domain})

    let subDomain;
    if(!domain) subDomain = await db.SubDomainGroup.findOne({groupName: domainFromEmail, deletedAt:null})
    console.log({subDomain})  

    if(!domain && !subDomain) throw new RequestError('Domain does not exist', 404)

    const company = domain ? await db.Company.findOne({ _id: domain.companyId }) : subDomain ? await db.Company.findOne({ _id: subDomain.companyId }) : null;
    console.log({company})

    if (!company) throw new RequestError('company does not exists', 404);    

    const companyRemainingTime = await db.MetaData.findOne({name:'expiredAt', companyId: company._id })
    if(new Date() > new Date(companyRemainingTime.value)) throw new RequestError('License expired', 404)

    let activeGroupsOfCompanyWithEmailAccess = await db.Group.find({ companyId: company._id, deletedAt: null, emailAccess: true }).select("_id")
    activeGroupsOfCompanyWithEmailAccess = activeGroupsOfCompanyWithEmailAccess.map(group=> group._id)

    const user = await db.User.findOne({
      email,
      emailType: type,
      isActive: true,
      companyId: company._id,
      groups: { $in: activeGroupsOfCompanyWithEmailAccess }, // Ensuring at least one active group
      deletedAt: null,
    });

    if (!user) throw new RequestError('user not exists', 404);

    const companyId = user.companyId;
    let isLicence
    if(!domain) isLicence = await db.Domain.findOne({ _id: subDomain.domainId, companyId, deletedAt: null }) !== null;
    else isLicence = await db.Domain.findOne({ domainName: domainFromEmail, companyId, deletedAt: null }) !== null

    let isLite = await db.CompanyFeature.findOne({
      companyId,
      featureCode: 'TPIR-VRE',
      deletedAt: null
    })
    if(!isLite) isLite = true;
    else isLite = false

    if(subDomain) {
      domain = await db.Domain.findOne({ _id: subDomain.domainId, deletedAt: null });
      if(!domain) throw new RequestError('Domain does not exist', 404);
    }
    
    return res.status(200).json({ success: true, isLicence, isLite, creds: domain.isCredential });
  } catch (err) {
    console.log(err);
    next(err);
  }
};

const apiRouter = express.Router();
apiRouter.route('/').post(htmlsanitize(),
//  validateBody(validator), 
 controller);
export default apiRouter;
