import Joi from 'joi';
import express from 'express';

import { queue } from '../../kue';
import getMailData from '../../service/get-mail-data';
import Spamc from 'spamc';
import config from '../../config';
import { sanitize } from '../../middlewares/sanitizer';
import { validateBody } from '../../middlewares/validator';
import { htmlsanitize } from '../../middlewares/sanitizeHtml';
import getUrls from 'get-urls';
import decodeUriComponent from 'decode-uri-component';
import canAccessFeature from '../../service/allowed-features';
import credentials from '../../service/credentials';
import mailer from '../../mailer';


// let validator = Joi.object().keys({
//     messageId: Joi.string().required(),
//     email: Joi.string().email().required(),
//     internetMessageId: Joi.string().required(), 
//     headers: Joi.string().required(), 
//     body: Joi.string().required()
// });

const checkUrlsForRid = async (urls) => {
    try {
        let urlContainsRid = false
        const urlsArray = Array.from(urls);

        for(let i=0; i<urlsArray.length;i++){
            let url = urlsArray[i]
            let decodedUrl = decodeURIComponent(url);
            if(decodedUrl.indexOf('rid=')>-1){
                urlContainsRid = decodedUrl
                break;
            }
        }
        return urlContainsRid
        
    } catch (err) {
        console.log(err);
        return false;
    }
}


const spamc = new Spamc(config.spamassession.host, config.spamassession.port, 10000);
/**
 * @api {post} /api/report/report-email report-email
 * @apiName Report Mail
 * @apiGroup Report
 * @apiDescription Report a mail
 * 
 * @apiVersion 1.0.0
 * 
 * @apiBody {String} accessToken       Required accessToken of the mail.
 * @apiBody {String} messageId         Required messageId of the mail.
 * @apiBody {String} email             Required email of the mail.
 *
 * @apiSuccess {Boolean} success    true
 * @apiSuccess {String} message    'email reported successfully'
 * 
  * @apiSuccessExample Success-Response:
 *     HTTP/1.1 200 OK
 *      {
 *          "success":  true,
 *          "message":  'email reported successfully'        
 *      } 
 * 
 * @apiError {Boolean}    success     false
 * @apiError {Boolean}    messages    ["user not exists"]
 * 
 * 
 * @apiErrorExample Error-Response:
 *     HTTP/1.1 404 Not Found
 *       {
 *           "success": false,
 *           "messages": [
 *               "user not exists"
 *           ]
 *       }
 */



let controller = async (req, res, next) => {
    try {
        const { messageId, email, internetMessageId, headers, body } = req.body;
        
        const user = await db.User.findOne({ email: email.toLowerCase(), isActive: true, emailType: "Outlook", deletedAt: null })
        if(!user){
            throw new RequestError('user not exists', 404);
        }
        console.log(user)
        const companyRemainingTime = await db.MetaData.findOne({name:'expiredAt', companyId: user.companyId })
        console.log({companyRemainingTime})
        if(new Date() > new Date(companyRemainingTime.value)) throw new RequestError('License expired', 404)

        const userId = user._id;
        const domainId = user.domainId;
        const companyId = user.companyId;
        

        const domain = await db.Domain.findOne({
            _id: domainId,
            companyId,
            deletedAt: null
        })
        console.log(domain)


        if(!domain){
            throw new RequestError('domain not exists', 404);
        }
        
        const isReported = await db.ReportedMail.findOne({ internetMessageId })
        if(isReported){
            await db.ReportedMail.updateOne({ _id:isReported._id }, { $push: { reporters: {email} } });
            if(await canAccessFeature(companyId,"TPIR-RN")) mailer.sendAlreadyReportedMail(user.name, email, companyId)
            res.status(200).json({ success: true, reporters: isReported.reporters ? isReported.reporters.length + 2 : 0, spamScore: isReported.spamScore, moveToJunk: true, message: 'email reported successfully'  });
        }
        else{
    
        const tsatUrl = await db.MetaData.findOne({
            companyId,
            name: 'tsatUrl'
        })
        const isTsat = await db.MetaData.findOne({
            companyId,
            name: 'isTsat'
        })
                
        let isTsatMail = isTsat.value === 'true';
        
        let urlsInbody = await getUrls(body)
        let isRidInBody = false
        if(urlsInbody.size > 0 ) isRidInBody = await checkUrlsForRid(urlsInbody)


        if (await canAccessFeature(companyId,"TPIR-TSAT") && isRidInBody != false && isTsatMail && tsatUrl.value) {
            // call to tsat for email reporting
            queue.create('route-email-tsat', { header: headers, body: decodeUriComponent(`${body}`), tsatUrl })
            .removeOnComplete(true).priority('high').save();
            
            return res.status(200).json({ success: true, message: 'email reported successfully', reporters: 1, moveToJunk: true, spamScore: 5 });
        }
        
        new Promise(async (resolve, reject) => {
            console.time('spamassession')
            if(await canAccessFeature(companyId,"TPIR-SSRE")){
                spamc.headers(headers, function (err, result) {
                   if(err) reject(err);
                   else resolve(result);
               })
            }
            else resolve(0)
        }).then(result => {
            console.log("SpamScore---->",result)
            console.timeEnd('spamassession')
            queue.create('reported-email-outlook', {
                email, 
                header: headers, 
                body, 
                eml: headers,
                userId,
                userName: user ? user.name ? user.name :'' :'', 
                domainId,
                companyId, 
                messageId, 
                internetMessageId,
                attachments: [], 
                folderId: '',
                spamScore: result && result.spamScore? result.spamScore: 0,
                isTsatMail: isRidInBody != false
            })
            .removeOnComplete(true).priority('high').save();

        res.status(200).json({ success: true, message: 'email reported successfully', reporters: 1, moveToJunk: true, spamScore: result && result.spamScore? result.spamScore: 0 });
        })   
    }
    } catch(err){
        console.log(err);
        next(err);
    }
}
const apiRouter = express.Router();
apiRouter.route('/').post( 
    // validateBody(validator),
     controller);
export default apiRouter;

