import Joi from 'joi';
import express from 'express';
import { sanitize } from '../../middlewares/sanitizer';
import { validateBody } from '../../middlewares/validator';
import { queue } from '../../kue';
import { checkCompanyValidityStrategy, jwtStrategy } from '../../middlewares/strategy';
import { updateReportedMailCache } from '../../functions';
import { htmlsanitize } from '../../middlewares/sanitizeHtml';
import restrictFeature from '../../middlewares/featureBlocker';
import { permission } from '../../middlewares/permission';

let validator = Joi.object().keys({
    reportedMailId: Joi.string().hex().length(24).required(),
    mailAction: Joi.string().allow(null).optional(),
  });

const controller = async (req, res, next) => {
  try {
       const mailAction = req.body.mailAction 

       const updateFields = {isWhoElseProcessing:true, syncStartAt: new Date(), isWhoElseError: false, isWhoElseProcessing: true, isWhoElseErrorMessage: "" }       
       if(mailAction!==null) updateFields.isMailActionProcessing = mailAction

       var reportedMail = await db.ReportedMail.findOne({_id: req.body.reportedMailId})
       if(!reportedMail) throw new RequestError("Mail not found!")

       if(reportedMail.isWhoElseProcessing) throw new RequestError('Who-Else search already in progress!')

       const domains = await db.Domain.find({companyId: req.user.companyId, isCredential: true, deletedAt: null})
       console.log({domains})
       if(!domains || !domains.length) throw new RequestError("Domain not found or credentials not uploaded!")

       const update =  await db.ReportedMail.findOneAndUpdate(
        { _id: req.body.reportedMailId },
        { $set: updateFields },
        { new: true } 
      )

      console.log({updated})
      const updated = await updateReportedMailCache(req.body.reportedMailId,{isWhoElseProcessing:true, syncStartAt: new Date(), isWhoElseError: false, isWhoElseProcessing: true, isWhoElseErrorMessage: ""})

      let bulkInsertMeta = [];
      for (let i = 0; i < domains.length; i++) {
          let domain = domains[i];
          if ((domain.domainType == 'Outlook' || domain.domainType == 'Gsuite') && domain.domainTypeForOutlook != "EXCHANGE" && domain.isCredential) {
              bulkInsertMeta.push({
                  isProcessing: false,
                  isCompleted:false,
                  reportedMailId: req.body.reportedMailId,
                  domainId: domain._id,
                  companyId: domain.companyId,
              });
          }
      }



      const updateWhoElseMetaData = await db.WhoElseMetaData.insertMany(bulkInsertMeta)
      let metadatas = await db.WhoElseMetaData.findOne({reportedMailId: req.body.reportedMailId})

      for(let i=0; i<domains.length; i++){
        let domain = domains[i];
        if(domain.domainType == 'Outlook' && domain.domainTypeForOutlook != "EXCHANGE" && domain.isCredential ){
          queue.create('email-reported-who-else-outlook', {
                reportedMailId: update._id,
                internetMessageId: update.internetMessageId, domainId: domain._id, companyId: update.companyId, 
                subject: update.subject, from: update.from, email:update.to, mailAction
           }).removeOnComplete(true).priority('high').save();          
        }
        else if (domain.domainType == 'Gsuite' && domain.isCredential){
          queue.create('email-reported-who-else-gsuite', {
                reportedMailId: update._id,
                internetMessageId:update.internetMessageId, domainId:domain._id, companyId: update.companyId, 
                subject: update.subject, from: update.from, email: update.to, mailAction
              }).removeOnComplete(true).priority('high').save();
        }
      }


      // if(update.mailType=='Outlook'){
      //   queue.create('email-reported-who-else-outlook', {
      //                   reportedMailId: update._id,
      //                   internetMessageId: update.internetMessageId, domainId: update.domainId, companyId: update.companyId, 
      //                   subject: update.subject, from: update.from, email:update.to, mailAction
      //               }).removeOnComplete(true).priority('high').save();

      // }
      // else{
      //   queue.create('email-reported-who-else-gsuite', {
      //                   reportedMailId: update._id,
      //                   internetMessageId:update.internetMessageId, domainId:update.domainId, companyId: update.companyId, 
      //                   subject: update.subject, from: update.from, email: update.to, mailAction
      //   }).removeOnComplete(true).priority('high').save();

      // }
        
        res.status(200).json({success:true})
  } catch (err) {
    console.log(err);
    await db.ReportedMail.updateOne(
      {
        _id: reportedMail._id,
        companyId: reportedMail.companyId,
      },
      {
        syncEndAt: new Date(),
        isWhoElseError: false,
        isWhoElseProcessing: false,
        isWhoElseErrorMessage: JSON.stringify(err),
        isWhoElseCompleted: false,
      }
    );
    await db.WhoElseMetaData.deleteMany({
      reportedMailId: reportedMail._id,         
      companyId: reportedMail.companyId,
   })
    next(err);
  }
};

const apiRouter = express.Router();

apiRouter.route('/').post(htmlsanitize(), jwtStrategy, restrictFeature("TPIR-WE"), checkCompanyValidityStrategy, permission('Emails','Write'), validateBody(validator), controller);

export default apiRouter;
