import Joi from 'joi';
import express from 'express';

import { permission } from '../../middlewares/permission';
import { sanitize } from '../../middlewares/sanitizer';
import { checkCompanyValidityStrategy, jwtStrategy } from '../../middlewares/strategy';
import { validateBody } from '../../middlewares/validator';
import { htmlsanitize } from '../../middlewares/sanitizeHtml';
import restrictFeature from '../../middlewares/featureBlocker';

let validator = Joi.object().keys({
    reportedMailId: Joi.string().hex().length(24).required()
});

/**
 * @api {post} /api/reported-email/attachments?reportedMailId=63b676c744ed3b8a72386597 attachments
 * @apiName attachments
 * @apiGroup reported-email
 * @apiDescription Attachments of the reported mail
 * 
 * @apiVersion 1.0.0
 * 
 * @apiQuery   {String} reportedMailId      Required Reported mail id of the reported mail
 * 
 * @apiSuccess {String} success             true
 * @apiSuccess {Array}  attachments         list of all attachments of the mail
 * 
 * @apiSuccessExample Success-Response:
 *      HTTP/1.1 200 OK 
 * 
 *      "success":  true,
 *      "attachments" :[
 *           {
 *               "_id": "63d0f16c78b9830aa47b3026",
 *               "attachmentId": "AAMkADg4N2I3ODU1LTg5MzgtNGJlOS05MDdmLTdkODQzY2UxODJlMABGAAAAAAAEeu5jAGlBSIzFYD0Uf00rBwDYeUh9annVS4gyZQy0RznfAAAAAAEMAADYeUh9annVS4gyZQy0RznfAABhlITtAAABEgAQAKQoNrvlMNBCmmja5uXbIAQ=",
 *               "fileName": "1674637676776.png",
 *               "originalName": "Screenshot 2023-01-13 at 5.44.25 PM.png",
 *               "mimeType": "png",
 *               "attachmentType": "image/png",
 *               "status": "NOT SCANNED",
 *               "result": null,
 *               "details": null,
 *               "reportedMailId": "63d0f16c78b9830aa47b3024",
 *               "__v": 0,
 *               "createdAt": "2023-01-25T09:07:56.783Z",
 *               "updatedAt": "2023-01-25T09:07:56.783Z"
 *           }
 *       ]
 * 
 * @apiError {Boolean} success             false
 * @apiError {Array}   messages            "\"reportedMailId\" is not allowed to be empty"
 * 
 * @apiSuccessExample Error-Response:
 *       HTTP/1.1 400 Not Found
 * 
 *      "success":   false,
 *      "messages" : "\"reportedMailId\" is not allowed to be empty"
 * 
 */

let controller = async (req, res, next) => {
    try {
        const { reportedMailId } = req.query;
        const attachments = await db.Attachment.find({
            reportedMailId
        })
        res.status(200).json({ success: true, attachments });
    } catch(err){
        console.log(err);
        next(err);
    }
}
const apiRouter = express.Router();
apiRouter.route('/').get(htmlsanitize(), validateBody(validator), jwtStrategy, restrictFeature("TPIR-VAUIR"), permission('Emails','Read'), controller);
export default apiRouter;