import Joi from 'joi';
import express from 'express';
import csvStream from "csv-parser";
import fs from 'fs'
import path from 'path'


import { permission } from '../../middlewares/permission';
import { sanitize } from '../../middlewares/sanitizer';
import { jwtStrategy } from '../../middlewares/strategy';
import { validateBody } from '../../middlewares/validator';
import { htmlsanitize } from '../../middlewares/sanitizeHtml';

let validator = Joi.object().keys({
  filter: Joi.object().keys({
    domainId: Joi.string().optional(),
    search: Joi.string().optional().allow(null).empty(''),
    isTrashedEmail: Joi.required(),
    isRecoveredEmail: Joi.required(),
    isDeletedEmail: Joi.required(),
    last15: Joi.required(),
    last30: Joi.required(),
    none: Joi.required(),
    custom: Joi.boolean().required(),
    toDate: Joi.date().required(),
    fromDate: Joi.date().required(),
    type: Joi.string().required(),
  })
});


let controller = async (req, res, next) => {
  try {
    const { last15, last30, custom, none, search = '', fromDate, toDate, type, isRecoveredEmail, isTrashedEmail, isDeletedEmail, domainId } = req.query.filter;

    const query = {};
    let domainsOfCurrentCompany = await db.Domain.find({
      companyId: req.user.companyId,
      deletedAt: null,
    }).select("domainType domainTypeForOutlook");
    console.log({domainsOfCurrentCompany})

    let uniqueDomains = new Set();// for doamin id

    domainsOfCurrentCompany.map((currentDomain) => {
      uniqueDomains.add(currentDomain._id);
    });
    let domainOfOutlookOrGsuite = [];
    let domainOfExchange = [];
    let idOfOutlookOrGsuite = [];
    let idOfExchange = [];

    domainsOfCurrentCompany.map((value) => {
      if (value.domainType === "Gsuite") {
        domainOfOutlookOrGsuite.push("Gsuite");
        idOfOutlookOrGsuite.push(value._id)
      } else if (value.domainType === "Outlook") {
        if (value.domainTypeForOutlook === "EXCHANGE") {
          domainOfExchange.push("Exchange");
          idOfExchange.push(value._id);
        }
         else {
          domainOfOutlookOrGsuite.push("Outlook");
          idOfOutlookOrGsuite.push(value._id)
        }
      }
    });

    domainsOfCurrentCompany = [...uniqueDomains];

    let uniqueDomainOfOutlookOrGsuite = new Set(); 
    let uniqueDomainOfExchange = new Set(); 

    domainOfOutlookOrGsuite.map((value) => {
      uniqueDomainOfOutlookOrGsuite.add(value);
    });
    
    domainOfExchange.map((value) => {
      uniqueDomainOfExchange.add(value);
    });
    
    domainOfOutlookOrGsuite = [...uniqueDomainOfOutlookOrGsuite];
    domainOfExchange = [...uniqueDomainOfExchange];

    domainsOfCurrentCompany = domainsOfCurrentCompany.map((value) => {
      return value._id;
    });

    query['companyId'] = req.user.companyId
    query['isRecoveredEmail'] = isRecoveredEmail
    query['isTrashedEmail'] = isTrashedEmail
    query['isDeletedEmail'] = isDeletedEmail

    if (domainId !== '-1') query['domainId'] = domainId;
    else {
       if(type=="outlookOrGsuite")
       query["domainId"]={ $in: idOfOutlookOrGsuite }
       else query["domainId"]={ $in: idOfExchange }
    }

    if (last15 !== 'false') {
      query['createdAt'] = { $gte: last15 };
    }
    if (last30 !== 'false') {
      query['createdAt'] = { $gte: last30 };
    }
    if (custom !== 'false') {
      query['createdAt'] = { $gte: fromDate, $lte: toDate };
    }
    if (type == 'outlookOrGsuite') {
      // query["mailType"] = { $in: ['Outlook', 'Gsuite' ] }
      query["mailtype"] = { $in: domainOfOutlookOrGsuite }
    }
    if (type == 'Exchange') {
      // query["mailType"] = { $in: ['Exchange'] }
      query["mailType"]={ $in: domainOfExchange }
    }
    if (search && search.length) {
      const regex = new RegExp(search, "i");
      query['$or'] = [
        { to: regex },
        { from: regex },
        { subject: regex },
      ]
    }

    const projection = {
      from: 1,
      to: 1,
      subject: 1,
      mailType: 1,
      mailRecievedTime: 1,
      createdAt: 1
    };
    console.log({ query });

    res.setHeader('Content-Type', 'text/csv');
    res.setHeader('Content-Disposition', 'attachment; filename=reported_mails.csv');

    // Create a temporary file path
    var tempFilePath = path.join(__dirname, `reported_mails.csv${domainId}`);

    // Create a write stream to the temporary file
    const writeStream = fs.createWriteStream(tempFilePath);
    writeStream.write(`from,to,subject,mailType,ReportedTime \n`)

    // Fetch documents using the cursor and write to CSV
    const cursor = db.ReportedMail.find(query, projection).cursor();



    // Wait for the 'finish' event to indicate that the write stream is ready
    writeStream.on('finish', () => {
      res.download(tempFilePath, () => {
        console.log({ tempFilePath });
        fs.unlinkSync(tempFilePath); // Remove the temporary file
      });
    });


    for await (const doc of cursor) {
      const rowData = {
        from: doc.from,
        to: doc.to,
        subject: doc.subject,
        mailType: doc.mailType,
        ReportedTime: doc.createdAt,
      };
      let str = `${doc.from},${doc.to},${doc.subject},${doc.mailType},${doc.createdAt.toLocaleString('en-IN', { timeZone: 'Asia/Kolkata' })} \n`
      writeStream.write(str);
    }

    writeStream.end(); // Signal the end of writing to the CSV

  } catch (err) {
    console.log(err);
    fs.unlinkSync(tempFilePath); // Remove the temporary file
    next(err);
  }

}
const apiRouter = express.Router();
apiRouter.route('/').get(htmlsanitize(), jwtStrategy, validateBody(validator), permission('Emails', 'Read'), controller);
export default apiRouter;

