import Joi from 'joi';
import express from 'express';

import { sanitize } from '../../middlewares/sanitizer';
import { checkCompanyValidityStrategy, jwtStrategy } from '../../middlewares/strategy';
import { validateBody } from '../../middlewares/validator';
import { permission } from '../../middlewares/permission';
import { htmlsanitize } from '../../middlewares/sanitizeHtml';
import restrictFeatre from '../../middlewares/featureBlocker'

let validator = Joi.object().keys({
    reportedMailId: Joi.string().hex().length(24).required()
});

/**
 * @api {post} /api/reported-email/urls?reportedMailId=63b676c744ed3b8a72386597 urls
 * @apiName  urls
 * @apiGroup reported-email
 * @apiDescription Urls of the reported mail
 * 
 * @apiVersion 1.0.0
 * 
 * @apiQuery   {String} reportedMailId      Required Reported mail id of the reported mail
 * 
 * @apiSuccess {String} success             true
 * @apiSuccess {Array}  urls                list of all urls of the mail
 * 
 * @apiSuccessExample Success-Response:
 *      HTTP/1.1 200 OK 
 * 
 *      "success":  true,
 *      "urls" :[
 *           {
 *               "_id": "63d0f16d78b9830aa47b302c",
 *               "url": "https://mixpanel.com/project/2327671",
 *               "deceptiveStatus": "false",
 *               "status": "NOT SCANNED",
 *               "domain": {
 *                   "tld": "com",
 *                   "domain": "mixpanel.com",
 *                   "subdomain": "",
 *                   "siteName": "mixpanel",
 *                   "href": "https://mixpanel.com/project/2327671",
 *                   "hostname": "mixpanel.com",
 *                   "protocol": "https:"
 *               },
 *               "result": null,
 *               "details": null,
 *               "scanId": [],
 *               "reportedMailId": "63d0f16c78b9830aa47b3024",
 *               "__v": 0,
 *               "createdAt": "2023-01-25T09:07:57.489Z",
 *               "updatedAt": "2023-01-25T09:07:57.489Z"
 *           },
 *
 *       ]
 *       
 * 
 * @apiError {Boolean} success             false
 * @apiError {Array}   messages            "\"reportedMailId\" is not allowed to be empty"
 * 
 * @apiSuccessExample Error-Response:
 *       HTTP/1.1 400 Not Found
 * 
 *      "success":   false,
 *      "messages" : "\"reportedMailId\" is not allowed to be empty"
 * 
 */

let controller = async (req, res, next) => {
    try {
        const { reportedMailId } = req.query;
        const urls = await db.Url.find({
            reportedMailId
        })
        res.status(200).json({ success: true, urls });
    } catch(err){
        console.log(err);
        next(err);
    }
}
const apiRouter = express.Router();
apiRouter.route('/').get(htmlsanitize(), validateBody(validator), jwtStrategy, restrictFeatre("TPIR-VAUIR"), permission('Emails','Read'), controller);
export default apiRouter;