import Joi from "joi";
import express from "express";
import { checkCompanyValidityStrategy, checkTaConnectionStrategy, jwtStrategy } from "../../middlewares/strategy";
import { permission } from "../../middlewares/permission";
import { validateBody } from "../../middlewares/validator";
import { htmlsanitize } from "../../middlewares/sanitizeHtml";

let validator = Joi.object().keys({
  employeeId: Joi.string().hex().length(24).required(),
  roleIds: Joi.array().items(
    Joi.string()
  )
});

let controller = async (req, res, next) => {
  try {
    let { employeeId, roleIds } = req.body;
    const companyId = req.user.companyId;
    const employee = await db.Employee.findOne({ companyId, _id: employeeId });
    if (!employee) {
      throw new RequestError("User does not exist");
    }
    
    let EmployeeRole = await db.EmployeeRole.findOne({ employeeId });
    
    if (roleIds.length === 0) {
      if (EmployeeRole) {
        await db.EmployeeRole.updateOne(
          { _id: EmployeeRole._id },
          { $set: { roleIds: [] } }
        );
      } else {
        await db.EmployeeRole.create({
          employeeId,
          roleIds: [],
          companyId
        });
      }
      return res.status(201).send({ success: true, message: "Role assigned successfully", roleIds: [] });
    }

    let filteredRoleIds = [];
    for (const roleId of roleIds) {
      const Role = await db.Role.findOne({ _id: roleId });
      if (!Role) {
        console.log("Role not found for id", roleId);
        continue;
      }
      filteredRoleIds.push(roleId);
    }

    if (EmployeeRole) {
      await db.EmployeeRole.updateOne(
        { _id: EmployeeRole._id },
        { $set: { roleIds: filteredRoleIds } }
      );
    } else {
      EmployeeRole = await db.EmployeeRole.create({
        employeeId,
        roleIds: filteredRoleIds,
        companyId
      });
    }
    
    res.status(201).send({ success: true, message: "Role assigned successfully", roleIds: filteredRoleIds });
  } catch (err) {
    console.log(err);
    next(err);
  }
};

const apiRouter = express.Router();
apiRouter
  .route("/")
  .post(
    htmlsanitize(),
    validateBody(validator),
    jwtStrategy,
    checkTaConnectionStrategy,
    checkCompanyValidityStrategy,
    permission("IAM", "Write"),
    controller
  );

export default apiRouter;
