import Joi from "joi";
import express from "express";
import { checkCompanyValidityStrategy, checkTaConnectionStrategy, jwtStrategy } from "../../middlewares/strategy";
import { permission } from "../../middlewares/permission";
import { validateBody } from "../../middlewares/validator";
import { htmlsanitize } from "../../middlewares/sanitizeHtml";

let validator = Joi.object().keys({
  policyData: Joi.array()
    .items(
       Joi.string()
    )
    .required(),
  roleName: Joi.string().required(),
  description: Joi.string()
});

let controller = async (req, res, next) => {
  try {
    let { policyData, roleName, description } = req.body;
    roleName = roleName.toLowerCase();
    const companyId = req.user.companyId;

    if(roleName == "admin" || roleName == "viewer" || roleName == "member") throw new RequestError("Role with same name already exists")
    const isExistingRole = await db.Role.findOne({ roleName: roleName.toLowerCase(), companyId });
    if (isExistingRole) {
      throw new RequestError("Role with same name already exists")
    }
   
    let policyIdArr = [];
    for (let i = 0; i < policyData.length; i++){
      let name  = policyData[i];
      const Policy = await db.Policy.findOne({ name });
      if(Policy && Policy._id)
       policyIdArr.push(Policy._id);
    }

    const Role = await db.Role.create({
      roleName: roleName.toLowerCase(),
      policyIds: policyIdArr,
      description,
      companyId
    });

    res
      .status(201)
      .send({ success: true, message: "Role created successfully" , Role});
  } catch (err) {
    console.log(err);
    next(err);
  }
};

const apiRouter = express.Router();
apiRouter
  .route("/")
  .post(
    htmlsanitize(),
    validateBody(validator),
    jwtStrategy,
    checkTaConnectionStrategy,
    checkCompanyValidityStrategy,
    permission("IAM", "Write"),
    controller
  );
export default apiRouter;
