import Joi from "joi";
import express from "express";
import { checkCompanyValidityStrategy, checkTaConnectionStrategy, jwtStrategy } from "../../middlewares/strategy";
import { permission } from "../../middlewares/permission";
import { validateBody } from "../../middlewares/validator";
import { htmlsanitize } from "../../middlewares/sanitizeHtml";

let validator = Joi.object().keys({
  roleId: Joi.string().hex().length(24).required()
});

let controller = async (req, res, next) => {
  try {
    const { roleId } = req.body;
    const companyId = req.user.companyId;


    const Role = await db.Role.findOne({
      _id: roleId,
    });

    if (!Role) {
      throw new RequestError("Role does not exists");
    };
    if (Role.roleType == 'Default') {
      throw new RequestError("Default Roles cannot be deleted!",403);
    }
      const employeeRoles = await db.EmployeeRole.find({ companyId });
      for (const employeeRole of employeeRoles) {
          if (employeeRole && employeeRole.roleIds && employeeRole.roleIds.length) {
              let newValueArr = employeeRole.roleIds.filter(val => {
                  return val !== Role._id;
              });
              await db.EmployeeRole.updateOne({ _id: employeeRole._id }, { $set: { roleIds: newValueArr } });
            }
      }
      await db.Role.deleteOne({ _id: Role._id });
    res
      .status(201)
      .send({ success: true, message: "Role deleted successfully", Role });
  } catch (err) {
    console.log(err);
    next(err);
  }
};

const apiRouter = express.Router();
apiRouter
  .route("/")
  .post(
    htmlsanitize(),
    validateBody(validator),
    jwtStrategy,
    checkTaConnectionStrategy,
    permission("IAM", "Write"),
    controller
  );
export default apiRouter;
