import Joi from "joi";
import express from "express";
import { checkCompanyValidityStrategy, jwtStrategy } from "../../middlewares/strategy";
import { permission } from "../../middlewares/permission";
import { validateBody } from "../../middlewares/validator";
import { htmlsanitize } from "../../middlewares/sanitizeHtml";

let validator = Joi.object().keys({
    roleName: Joi.string().required(),
    roleType: Joi.string().required()
});

let controller = async (req, res, next) => {
  try {
    const { roleName, roleType } = req.body 
    const companyId = req.user.companyId;

    let role;
    if(roleType == "Default"){
      role = await db.Role.findOne({ roleName })
      .select('roleName description roleType')
      .populate({
          path: 'policyIds',
          select: 'name'
      });
    }
    else{
      role = await db.Role.findOne({ companyId, roleName })
      .select('roleName description roleType')
      .populate({
          path: 'policyIds',
          select: 'name'
      });
    }

    const transformedRole = {
    roleId: role._id,
    roleName: role.roleName,
    description: role.description,
    policies: role.policyIds.map(policy => policy.name),
    roleType: role.roleType
    };


    res.status(201).send({ success: true, message: "Role fetched successfully", role: transformedRole });
  } catch (err) {
    console.log(err);
    next(err);
  }
};

const apiRouter = express.Router();
apiRouter
  .route("/")
  .post(
    htmlsanitize(),
    jwtStrategy,
    validateBody(validator),
    checkCompanyValidityStrategy,
    permission("IAM", "Read"),
    controller
  );
export default apiRouter;
