import Joi from "joi";
import express from "express";
import { checkCompanyValidityStrategy, jwtStrategy } from "../../middlewares/strategy";
import { permission } from "../../middlewares/permission";
import { validateBody } from "../../middlewares/validator";
import { htmlsanitize } from "../../middlewares/sanitizeHtml";

// let validator = Joi.object().keys({
//   companyId: Joi.string().hex().length(24).required(),
  
// });

let controller = async (req, res, next) => {
  try {
    const companyId = req.user.companyId;
      let roles = await db.Role.find({ companyId }).select('roleName roleType description');
      let defaultRoles = await db.Role.find({roleType:"Default"});
      roles = [...roles, ...defaultRoles]
    res.status(201).send({ success: true, message: "Role fetched successfully", roles });
  } catch (err) {
    console.log(err);
    next(err);
  }
};

const apiRouter = express.Router();
apiRouter
  .route("/")
  .get(
    htmlsanitize(),
    jwtStrategy,
    permission("IAM", "Read"),
    controller
  );
export default apiRouter;
