import express from "express";

let controller = async (req, res, next) => {
    try {
    
      let adminPolicyIds = [];
      let adminDescription = "An admin has full access to all functionalities, including creating, editing, and deleting content, managing user roles, and accessing all settings and configurations."
      let memberPolicies = [];
      let memberDescription = "A member can view, create, and edit content but cannot manage user roles or access sensitive settings. Members have the ability to contribute to and modify existing resources."
      let viewerPolicies = [];
      let viewerDescription = "A viewer has read-only access, allowing them to view content without the ability to make any changes or edits. Viewers cannot create, edit, or delete content."
      let Policies = await db.Policy.find({});
      if (!Policies) {
          throw "Policies Not found";
      }
      Policies.forEach(policy => {
          let suffix = policy.name.split('-')[1];
          let prefix = policy.name.split('-')[0];
          if (suffix == 'Read') {
              adminPolicyIds.push(policy._id.toHexString());
              memberPolicies.push(policy._id.toHexString());
              viewerPolicies.push(policy._id.toHexString());
          }
          if (suffix == 'Write') {
              if (['Domain', 'Emails', 'AdvancedSearch', 'Settings'].includes(prefix)) {
                  memberPolicies.push(policy._id.toHexString());
              }
              adminPolicyIds.push(policy._id.toHexString());
          }
          if (suffix == 'Delete') {
              adminPolicyIds.push(policy._id.toHexString());
          }
      })
        
        // let companies = await db.Company.find({});
        // for (const company of companies) {
            await db.Role.create({
                roleName: "admin",
                policyIds: adminPolicyIds,
                companyId: null,
                description: adminDescription,
                roleType: "Default"
            })
            await db.Role.create({
                roleName: "member",
                policyIds: memberPolicies,
                companyId: null,
                description: memberDescription,
                roleType: "Default"
            })
            await db.Role.create({
                roleName: "viewer",
                policyIds: viewerPolicies,
                companyId: null,
                description: viewerDescription,
                roleType: "Default"
            })
        
    res.status(201).send({ success: true });
  } catch (err) {
    console.log(err);
    next(err);
  }
};

const apiRouter = express.Router();
apiRouter.route("/").get(controller);
export default apiRouter;
