import express from 'express';

import config from '../../config';
import { jwtStrategy } from '../../middlewares/strategy';


  

let controller = async (req, res, next) => {
    try {

        const attachments = await db.Attachment.find({})
        const urls = await db.Url.find({})
         
        
        attachments.forEach(async function(doc) {
            if (doc && doc.result !== null && typeof doc.result.scans === 'object') {
                var detectedCount = 0;
            var totalCount = 0;
            
            for (const key in doc.result.scans) {
                if (doc.result.scans[key].detected) {
                  detectedCount++;
                }
                totalCount++;
              }
          
          
            var percentage = (detectedCount / totalCount) * 100;
          
            const result = await db.Attachment.updateOne(
              { _id: doc._id },
              { $set: { score: percentage }},
              {returnOriginal: false}
              
            );

        }
        });

        urls.forEach(async function(doc) {
            if (doc && doc.result !== null && typeof doc.result.scans === 'object') {
                var detectedCount = 0;
                var totalCount = 0;
            
            for (const key in doc.result.scans) {
                if (doc.result.scans[key].detected) {
                  detectedCount++;
                }
                totalCount++;
              }
          
          
            var percentage = (detectedCount / totalCount) * 100;
          
            const result = await db.Url.updateOne(
              { _id: doc._id },
              { $set: { score: percentage }},
              {returnOriginal: false}
              
            );

        }
        });
          
     

          
        res.status(200).send({success: true})
       
    } catch (error) {
        console.log(error);
        next(error);
    }
}

const apiRouter = express.Router();
apiRouter.route('/').get(controller);
export default apiRouter;

