import Joi from 'joi';
import express from 'express';

import { sanitize } from '../../middlewares/sanitizer';
import { checkCompanyValidityStrategy, jwtStrategy } from '../../middlewares/strategy';
import totalvirus from '../../service/get-virus-totalkey';
import { validateBody } from '../../middlewares/validator';
import scanResultUrl from '../../service/result-url-totalvirus';
import { htmlsanitize } from '../../middlewares/sanitizeHtml';
import restrictFeature from '../../middlewares/featureBlocker';

let validator = Joi.object().keys({
    urlId: Joi.string().hex().length(24).required()
});

/**
 * @api {post} /api/report/reported-emails Request User information
 * @apiName Email Report
 * @apiGroup Report
 * 
 * @apiVersion 1.0.0
 * 
 * @apiSuccess {String} success    status of the request.
 * @apiSuccess {String} message    success message.
 */

let controller = async (req, res, next) => {
    try {
        const { urlId } = req.query;
        const companyId = req.user.companyId;
        const attachment = await db.Url.findById(urlId)
        if(!attachment){
            throw new RequestError('Invalid urlId recieved');
        }
        if(!attachment?.result?.scan_id){
            throw new RequestError('first scan the attachment file')
        }
        const { scan_id } = attachment.result.scan_id;
        const apikey = await totalvirus.getApiKey(companyId);
        scanResultUrl.processScanResult({
            apikey: apikey,
            scan_id: scan_id
        })
        .then(async data => {
            await db.Url.updateOne({
                _id: urlId,
            }, {
                status: 'COMPLETED',
                result: data
            })
            if(data.response_code == -2 || data.verbose_msg){
                return [data.verbose_msg, false]
            } else {
                return ['scan result fetch successfully', true]
            }
        })
        .then(([message, isRefresh]) => {
            res.status(200).json({ success: true, isRefresh, message });
        })
        .catch(err => {
            console.log(err);
            db.Url.updateOne({
                _id: urlId,
            }, {
                status: 'FAILED',
                details: err
            })
            next(err);
        })
    } catch(err){
        console.log(err);
        next(err);
    }
}
const apiRouter = express.Router();
apiRouter.route('/').get(htmlsanitize(), validateBody(validator), jwtStrategy, restrictFeature("TPIR-AALP"), checkCompanyValidityStrategy, controller);
export default apiRouter;