import Joi from 'joi';
import express from 'express';

import { jwtStrategy } from '../../middlewares/strategy';


const controller = async (req, res, next) => {
    try {
        const companyId = req.user.companyId;

        const isLite = (await db.Company.findOne({
            _id: companyId
        })).isLite

        let companyFeatures = await db.CompanyFeature.find({companyId}).select({_id:0, featureCode:1})
        companyFeatures = companyFeatures.map(feature=>feature.featureCode)

        return res.status(200).send({ success: true, isLite, companyFeatures })
    } catch (error) {
        console.log('error', error);
        next(error)
    }
}

const apiRouter = express.Router();
apiRouter.route('/').get(jwtStrategy, controller);
export default apiRouter;