import Joi from 'joi';
import express from 'express';

import { sanitize } from '../../middlewares/sanitizer';
import { jwtStrategy } from '../../middlewares/strategy';
import { validateBody } from '../../middlewares/validator';
import { permission } from '../../middlewares/permission';
import { htmlsanitize } from '../../middlewares/sanitizeHtml';

const validator = Joi.object().keys({
    licenceKey: Joi.string().required()
});

const controller = async (req, res, next) => {
    try {
        const { licenceKey } = req.body;
        const companyId = req.user.companyId;

        await db.Company.updateOne({
            _id: companyId
        }, {
            licenceKey
        })

        return res.status(200).send({ Success: true, message: 'Licence key updated successfully' })
    } catch (error) {
        console.log('error', error);
        next(error)
    }
}

const apiRouter = express.Router();
apiRouter.route('/').post(htmlsanitize() , jwtStrategy, permission('Settings','Write'), validateBody(validator), controller);
export default apiRouter;