import Joi from 'joi';
import express from 'express';

import { sanitize } from '../../middlewares/sanitizer';
import { jwtStrategy } from '../../middlewares/strategy';
import { validateBody } from '../../middlewares/validator';
import { permission } from '../../middlewares/permission';
import mailer from '../../mailer'
import { htmlsanitize } from '../../middlewares/sanitizeHtml';

const validator = Joi.object().keys({
    testMail: Joi.string().required(),
});

const controller = async (req, res, next) => {
    try {
        const { testMail } = req.body;
        const userName = req.user.firstName;
        const companyId = req.user.companyId;
        console.log(req.body)
        await mailer.sendTestMail(testMail, companyId, userName)
        return res.status(200).send({ success: true, message: "Succesfully sent a test mail!"})

    } catch (error) {
        console.log('error', error);
        next(new RequestError('Unable to send test mail! Kindly check credentials.'))
    }
}

const apiRouter = express.Router();
apiRouter.route('/').post(htmlsanitize(), jwtStrategy, permission('Settings','Write'),validateBody(validator),controller);
export default apiRouter;