import Joi from 'joi';
import express from 'express';

import { sanitize } from '../../middlewares/sanitizer';
import { jwtStrategy } from '../../middlewares/strategy';
import { validateBody } from '../../middlewares/validator';
import { permission } from '../../middlewares/permission';
import { htmlsanitize } from '../../middlewares/sanitizeHtml';

const validator = Joi.object().keys({
    tsatUrl: Joi.string(),
    status: Joi.boolean()
});

const controller = async (req, res, next) => {
    try {
        const { tsatUrl, status } = req.body;
        const companyId = req.user.companyId;
        
        if(status !== undefined) await db.MetaData.updateOne({ companyId, name: 'isTsat'},{ value: status})
        if(tsatUrl !== undefined) await db.MetaData.updateOne({ companyId, name: 'tsatUrl'},{ value: tsatUrl})
        
        let response = { Success: true, message: 'Tsat Configuration updated successfully' }
        if (tsatUrl) response.tsatUrl = tsatUrl
        else response.status =status

        return res.status(200).send(response)
    } catch (error) {
        console.log('error', error);
        next(error)
    }
}

const apiRouter = express.Router();
apiRouter.route('/').post(htmlsanitize(), jwtStrategy, permission('Settings','Write'), validateBody(validator), controller);
export default apiRouter;