import Joi from 'joi';
import express from 'express';

import { sanitize } from '../../middlewares/sanitizer';
import { jwtStrategy } from '../../middlewares/strategy';
import { validateBody } from '../../middlewares/validator';
import { permission } from '../../middlewares/permission';
import { htmlsanitize } from '../../middlewares/sanitizeHtml';

const validator = Joi.object().keys({
    broadcastEnabled: Joi.boolean().required(),
    broadcastThreshold: Joi.number().required(),
});

const controller = async (req, res, next) => {
    try {
        const companyId = req.user.companyId;
        const { broadcastEnabled, broadcastThreshold } = req.body;

        const company = await db.Company.findById(companyId)
        if(!company) throw new RequestError('Invalid companyId received!')

        await db.Company.updateOne({_id: companyId},{ broadcastThreshold: broadcastEnabled == false ? 0 : broadcastThreshold})
        
        if(broadcastEnabled) return res.status(200).send({success: true, message: "Broadcast email threshold updated successfully!"})
        else return res.status(200).send({success: true, message: "Broadcast disabled successfully!"})
        
    } catch (error) {
        console.log('error', error);
        next(error)
    }
}

const apiRouter = express.Router();
apiRouter.route('/').post(htmlsanitize(), jwtStrategy, permission('Settings','Write'),validateBody(validator), controller);
export default apiRouter;