import Joi from 'joi';
import express from 'express';

import { sanitize } from '../../middlewares/sanitizer';
import { jwtStrategy } from '../../middlewares/strategy';
import { validateBody } from '../../middlewares/validator';
import { permission } from '../../middlewares/permission';
import { htmlsanitize } from '../../middlewares/sanitizeHtml';

const validator = Joi.object().keys({
    messengerEnabled: Joi.boolean().required(),
});

const controller = async (req, res, next) => {
    try {
        const companyId = req.user.companyId;
        const { messengerEnabled } = req.body;

        const company = await db.Company.findById(companyId)
        if(!company) throw new RequestError('Invalid companyId received!')

        let metadata = await db.MetaData.findOne({
            companyId, name: 'isMessengerEnabled'
        })
        if(metadata){
            await db.MetaData.updateOne({
                _id: metadata._id
            }, {
                value: messengerEnabled
            })
        } else {
            await db.MetaData.create({
                companyId,
                name: 'isMessengerEnabled',
                value: messengerEnabled
            })
        }
        
        return res.status(200).json({
            success: true,
            message: "Messenger configuration updated successfully!"
        });
    } catch (error) {
        console.log('error', error);
        next(error)
    }
}

const apiRouter = express.Router();
apiRouter.route('/').post(htmlsanitize(), jwtStrategy, permission('Settings','Write'),validateBody(validator), controller);
export default apiRouter;