import Joi from 'joi';
import express from 'express';

import { sanitize } from '../../middlewares/sanitizer';
import { jwtStrategy } from '../../middlewares/strategy';
import { validateBody } from '../../middlewares/validator';
import { permission } from '../../middlewares/permission';
import { htmlsanitize } from '../../middlewares/sanitizeHtml';

const validator = Joi.object().keys({
    defaultReportingMethod: Joi.boolean().required(),
});

const controller = async (req, res, next) => {
    try {
        const companyId = req.user.companyId;
        const { defaultReportingMethod } = req.body;

        let company = await db.Company.findOne({_id: companyId, deletedAt: null})
        if(!company) throw new RequestError("Company not found!")

        if(defaultReportingMethod){
            await db.Company.updateOne({_id: companyId, deletedAt: null}, { reportingMethod: "Default" })
            await db.Domain.updateMany({companyId, domainTypeForOutlook: "OFFICE365", deletedAt: null},{ webhookEmail: null})
        }
        else{
            await db.Company.updateOne({_id: companyId, deletedAt: null}, { reportingMethod: "Email Client" })
        }
        
        return res.status(200).json({
            success: true,
            message: "Reporting method updated successfully!"
        });
    } catch (error) {
        console.log('error', error);
        next(error)
    }
}

const apiRouter = express.Router();
apiRouter.route('/').post(htmlsanitize(), jwtStrategy, permission('Settings','Write'), validateBody(validator), controller);
export default apiRouter;